#include <stdio.h>
#include <assert.h>
#include <allegro.h>
#include "mengine.h"

enum GfxMode { GFX640X480, GFX320X240 };

class HeartBeat
{
private:
    BITMAP *buffer;
    MainEngine m;
    friend void timer_handler ();
    static volatile int counter;  // timer counter
    int update_counter;
    int update_count; // #msec between updates
    int frame_counter;
    int frame_count; // count number of frames drawn.
    int last_fps;
    GfxMode gfxMode;
public:
    HeartBeat ();
    void useGfxMode (GfxMode newGfxMode);
    int init ();
    void run ();
    void exit ();
};

volatile int HeartBeat::counter = 0;

void timer_handler()
{
    HeartBeat::counter += 10;
}

END_OF_FUNCTION(timer_handler);

void HeartBeat::useGfxMode (GfxMode newGfxMode)
{
    gfxMode = newGfxMode;
}

HeartBeat::HeartBeat()
{
    update_count = 33; // update each 33 msec, or 30 times / sec
    update_counter = 0;
    frame_count = 0;
    frame_counter = 0;
    last_fps = 0;
    gfxMode = GFX640X480;
}

int HeartBeat::init ()
{
    LOCK_VARIABLE(HeartBeat::counter);
    LOCK_FUNCTION(timer_handler);
    if (allegro_init () < 0)
    {
        allegro_message ("init failed");
        return 0;
    }
    if (install_keyboard () < 0)
    {
        allegro_message ("install keyboard failed");
        return 0;
    }
    if (install_timer() < 0)
    {
        allegro_message ("install timer failed");
        return 0;
    }
    if (install_int (timer_handler, 10) < 0)
    {
        allegro_message ("installation of timer handler failed");
        return 0;
    }
    switch (gfxMode)
    {
    case GFX320X240:
//        if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,320,240,0,0)!=0)
  //      {
            // otherwise full screen will do
            if (set_gfx_mode(GFX_AUTODETECT,320,240,0,0)!=0)
            {
                allegro_message("Unable initialize graphics module\n%s\n", allegro_error);
                return 0;
            }
    //    }
        break;
    case GFX640X480:
    default:
//        if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0)!=0)
  //      {
            // otherwise full screen will do
            if (set_gfx_mode(GFX_AUTODETECT,640,480,0,0)!=0)
            {
                allegro_message("Unable initialize graphics module\n%s\n", allegro_error);
                return 0;
            }
    //    }
        break;
    }
    buffer = create_bitmap(SCREEN_W, SCREEN_H);
    if (!buffer)
    {
        allegro_message ("Error creating background buffer");
        return 0;
    }
    if (!m.activate ())
    {
        return 0;
    }
    set_window_title ("Magic Maze");
    return 1;
}

void HeartBeat::exit ()
{
    m.deactivate ();
    destroy_bitmap(buffer);
    allegro_exit ();
}

void HeartBeat::run ()
{
    while (!m.finished())
    {
        while ((counter - update_counter) > update_count)
        {
            update_counter += update_count;
            int update_start = counter;
            m.update (counter);

            // check to see if update takes too long
            if (counter - update_start > update_count)
            {
                // we probably can't catch up anymore.
                // move update_counter ahead, or we have to
                // catch up even more next loop
                update_counter = counter;
                break;
            }
        }
        m.draw (buffer);
        //uncomment for Framerate counter on screen
        //textprintf (buffer, font, 0, 0, makecol (255, 255, 255), "fps: %d", last_fps);

        acquire_screen();
        blit (buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
        release_screen();

        if ((counter - frame_counter) > 1000)
        {
            last_fps = frame_count;
            frame_count = 0;
            frame_counter = counter;
        }
        frame_count++;
        vsync();
    }
}

int main (int argc, char *argv[])
{
    HeartBeat h;

    int i;
    for (i = 1; i < argc; i++)
    {
        if (strcmp (argv[i], "320x240") == 0)
        {
            h.useGfxMode (GFX320X240);
        }
        if (strcmp (argv[i], "640x480") == 0)
        {
            h.useGfxMode (GFX640X480);
        }
    }

    if (h.init ())
    {
        h.run();
        h.exit ();
    }
    return 0;
}

END_OF_MAIN ();
