/*
  JBdraw

  drawing primitives by Jules Beulen.
*/

#include <allegro.h>

void drawcircle (BITMAP *buffer, int xc, int yc, int color )
{
 //int xc; int yc;
 circlefill(buffer, xc, yc, 8, color);
   circle(buffer, xc, yc, 8, 1);
}

void drawarrowleft (BITMAP *buffer, int xa, int ya, int color )
{
   int x2,y2,x3,y3;
   x2=xa+8; y2=ya+8;
   x3=xa+8; y3=ya-8;
   triangle(buffer,  xa, ya, x2, y2, x3, y3, color);
   line(buffer,  xa, ya,  x2,  y2, 1);
   line(buffer,  xa,  ya, x3,  y3, 1);
   line(buffer,  x2,  y2, x3,  y3, 1);
}

void drawarrowright (BITMAP *buffer, int xa, int ya, int color )
{
   int x2,y2,x3,y3;
   x2=xa-8; y2=ya+8;
   x3=xa-8; y3=ya-8;
   triangle(buffer,  xa, ya, x2, y2, x3, y3, color);
   line(buffer,  xa, ya,  x2,  y2, 1);
   line(buffer,  xa,  ya, x3,  y3, 1);
   line(buffer,  x2,  y2, x3,  y3, 1);
}

void drawbox (BITMAP *buffer, int xb1, int xb2, int yb, int height, int color)
{
   // the bottom of the box is yb plus the radius of the circle
   // the top of the box is yb minus height minus the radius of the circle
   // actual height is the height plus 2 times the radius
   // actual width is xb2-xb1 plus 2 times the radius
   
   int yb1, yb2; 
   yb1=yb; yb2=yb1-height; // edge of boxes
   int ra; // radius of circle used here
   ra=8;
   drawcircle (buffer, xb1, yb1, color);
   drawcircle (buffer, xb1, yb2, color);
   drawcircle (buffer, xb2, yb1, color);
   drawcircle (buffer, xb2, yb2, color);
   rectfill(buffer, xb1, (yb-height-ra), xb2, (yb+ra), color); // fill central chunk of box
   line(buffer,  xb1, (yb-height-ra),  xb2,  (yb-height-ra), 1); // line at top
   line(buffer,  xb1, (yb+ra),  xb2,  (yb+ra), 1); // line at bottom
   rectfill(buffer, (xb1-ra), yb1, xb1, yb2, color); // fill left chunk of box
   line(buffer,  (xb1-ra), yb1, (xb1-ra), yb2, 1); // line at leftside
   rectfill(buffer, (xb2+ra), yb1, xb2, yb2, color); // fill right chunk of box
   line(buffer,  (xb2+ra), yb1, (xb2+ra), yb2, 1); // line at rightside
   // a quick solution so height can be any value, normally 
   // height=0 is ok but otherwise it should be at least 8 (that the radius)
   // now we solve that by drawing a circle that a radius-1
   // needless to say this will not work with all radiuses ;-)
   circlefill(buffer, xb1, yb1, (ra-1), color);
   circlefill(buffer, xb1, yb2, (ra-1), color);
   circlefill(buffer, xb2, yb1, (ra-1), color);
   circlefill(buffer, xb2, yb2, (ra-1), color);
}

void doubleprintf_centre(BITMAP *bmp, AL_CONST FONT *f, int x, int y, int color1, int color2, AL_CONST char *format, ...)
{
   char buf[512];

   va_list ap;
   va_start(ap, format);
   uvszprintf(buf, sizeof(buf), format, ap);
   va_end(ap);

   textout_centre(bmp, f, buf, x + 1, y + 1, color2);
   textout_centre(bmp, f, buf, x, y, color1);
}

