#include <allegro.h>
#include "hiscore.h"
#include "shandler.h"
#include "game.h"
#include "menu.h"

#ifndef NO_SOUND
#include "jgmod.h"
#endif

class MainEngine
{
private:
#ifndef NO_SOUND
    JGMOD *ex;
#endif
    HiScore hiscore;
    int sequence;
    bool main_loop;
    void definecolors();
    BITMAP *background;
    void createbackground();
    ScoreHandler score;
    GameEngine ge;
    Menu menu;
    DATAFILE *data;
    FONT *font6, *font12;
public:
    void draw (BITMAP *buffer);
    void update (int msec);
    int activate ();
    void deactivate ();
    bool finished () { return !main_loop; }
};
