#ifndef MAZE_AI_H
#define MAZE_AI_H

const int player_max = 4;
const int max_size = 9;

typedef int map_type[max_size][max_size];

class player_class
{
public:
    int xco, yco;
    int tr_x, tr_y;
    int type;
    int score;
    int time;
};

const int COMPUTER = 1, HUMAN = 2, UNUSED = 0;

typedef player_class players_type[player_max];

void do_magic_turn (map_type &map, int cursor, int direction,
    int &rest_card, players_type &player, int map_size);
int get_access_table (map_type &access, map_type &map, int xstart, int ystart, int map_size);
void comp_magic_turn (map_type &map, int &cursor, int &direction,
    int &rest_card, int current, players_type &player, int map_size);
void find_way (int current, map_type &direction, map_type &map, players_type &player, int map_size);
void access_to_direction (map_type &access, map_type &map,
    int target_x, int target_y, int map_size);
void adjust_target (map_type &access, int &target_x, int &target_y, int map_size);
void initMap (map_type &map, int &rest_card, int map_size);
void init_treasure (int i, players_type player, int map_size);
void initPlayers (players_type player, int map_size);

#endif
