#ifndef _3D_H
#define _3D_H

void render(BITMAP *bmp, BITMAP *texture);
int do_animation ();
void process_input();

void board_move_to (int b, int x, int y, int step);
void board_rotate_to (int b, int r, int step);
void camera_pitch_to (int r, int step);
void camera_rotate_to (int r, int step);
void swap_board_in (int step);
void swap_board_out (int step);
void swap_card_in (int x, int y, int step);
void swap_card_out (int step);
void make_board (int tx_size);
void make_split (int w0, int h0, int x1, int y1, int w1, int h1,
    int w2, int h2, int x2, int y2);
void make_card (int tx_size, int x, int y);
void init_3D (int map_size);

#endif
