#include "maze_ai.h"
#include <stdlib.h>

void initMap (map_type &map, int &rest_card, int map_size)
{
    // clear the map
    int i, j;
    for (i = 0; i < max_size; i++)
        for (j = 0; j < max_size; j++)
            map [i][j] = 0;

    // fill the fixed ones
    map [0][0] = 6;
    map [map_size-1][0] = 12;
    map [0][map_size-1] = 3;
    map [map_size-1][map_size-1] = 9;

    for (i = 2; i < map_size-2; i+=2)
    {
        map [0][i] = 7;
        map [map_size-1][i] = 13;
        map [i][0] = 14;
        map [i][map_size-1] = 11;
        for (j = 2; j < map_size-2; j+=2)
        {
            switch (rand () % 4)
            {
            case 0: map [i][j] = 7; break;
            case 1: map [i][j] = 11; break;
            case 2: map [i][j] = 13; break;
            case 3: map [i][j] = 14; break;
            }
        }
    }

    // fill the empty spaces.
    // Make sure the corners, straigts and T-crossings are equally
    // distrubuted
    const int allowed [3][4] =
        {{3, 6, 12, 9}, {5, 10, 5, 10}, {7, 14, 13, 11}};
    int total_pick = map_size * map_size;
    int pick[3];
    pick[0] = total_pick / 3;
    pick[1] = total_pick / 3;
    pick[2] = total_pick - pick[0] - pick[1];

    pick[2] -= ((map_size + 1) * (map_size + 1) / 4 - 4);
    pick[0] -= 4;

    for (i = 0; i < map_size; i++)
    {
        for (j = 0; j < map_size; j++)
        {
            if (map[i][j] == 0)
            {
                int p;
                do { p = rand () % 3; } while (pick[p] == 0);
                map [i][j] = allowed[p][rand () % 4];
                pick[p] --;
            }
        }
    }

    rest_card = allowed[rand() % 3][rand() % 4];
}

void do_magic_turn (map_type &map, int cursor, int direction,
    int &rest_card, players_type &player, int map_size)
{
    // do the move
    int xco, yco, dx, dy, swap, i;
    switch (direction)
    {
    case 0: xco = cursor; yco = 0; dx = 0; dy = 1; break;
    case 1: xco = map_size-1; yco = cursor; dx = -1; dy = 0; break;
    case 2: xco = cursor; yco = map_size-1; dx = 0; dy = -1; break;
    case 3: xco = 0; yco = cursor; dx = 1; dy = 0; break;
    }

    // make players and treasures move together with maze
    for (i = 0; i < player_max; i++) if (player[i].type != UNUSED)
    {
        if (dy == 0)
        {
            if (player[i].yco == yco)
            {
                player[i].xco += dx;
                if (player[i].xco < 0) player[i].xco = map_size-1;
                if (player[i].xco >= map_size) player[i].xco = 0;
            }
            if (player[i].tr_y == yco)
            {
                player[i].tr_x += dx;
                if (player[i].tr_x < 0) player[i].tr_x = map_size-1;
                if (player[i].tr_x >= map_size) player[i].tr_x = 0;
            }
        } else {
            if (player[i].xco == xco)
            {
                player[i].yco += dy;
                if (player[i].yco < 0) player[i].yco = map_size-1;
                if (player[i].yco >= map_size) player[i].yco = 0;
            }
            if (player[i].tr_x == xco)
            {
                player[i].tr_y += dy;
                if (player[i].tr_y < 0) player[i].tr_y = map_size-1;
                if (player[i].tr_y >= map_size) player[i].tr_y = 0;
            }
        }
    }

    // make all blocks in a row move.
    for (i = 0; i < map_size; i++)
    {
        swap = map [xco][yco];
        map [xco][yco] = rest_card;
        rest_card = swap;
        xco += dx;
        yco += dy;
    }
}

/*
   get access table returns a table in which a zero means that this
   tile is not accessible. any other number is the number of tiles that
   are closer to the start position than this one. The returned int
   is the number of accessible tiles.
*/

int get_access_table (map_type &access, map_type &map, int xstart, int ystart, int map_size)
{
    const int mask [4] = {1, 2, 4, 8};
    const int opposite [4] = {4, 8, 1, 2};

    int xrec [max_size * max_size], yrec [max_size * max_size];

    int x, y;
    int dx, dy, nx, ny, i, swap;
    int now = 0;
    int add = 1;
    xrec[now] = xstart;
    yrec[now] = ystart;

    // clear all access
    for (x = 0; x < max_size; x++) for (y = 0; y < max_size; y++)
    {
        access[x][y] = 0;
    }

    access [xrec[now]][yrec[now]] = 1;

    do {
        //for each direction
        dx = 0; dy = -1; // first direction

        for (i = 0; i < 4; i++)
        {
            nx = xrec[now] + dx;
            ny = yrec[now] + dy;

            if ((nx >= 0) && (nx < map_size) &&
                (ny >= 0) && (ny < map_size) &&
                (access[nx][ny] == 0) &&
                (map[xrec[now]][yrec[now]] & mask[i]) &&
                (map[nx][ny] & opposite[i]))
            {
                xrec[add] = nx;
                yrec[add] = ny;
                add++;
                access[nx][ny] = add;
            }

            swap = -dy; dy = dx; dx = swap; // turn 90 degrees
        }
        now++; // next stored coordinate
    } while (add != now);

    return add;
}

void comp_magic_turn (map_type &map, int &cursor, int &direction,
    int &rest_card, int current, players_type &player, int map_size)
{
    int max_score = max_size * max_size + 1;
        // score for obtaining treasure
    int irest_cards[4];

    cursor = 0; direction = 0;

    // loop through all different possible moves
    int irest_card, temp, i;
    int icursor, idirection;
    players_type iplayer;
    map_type imap, access;
    int highest = 0, hrest_card = rest_card, hcursor = 0, hdirection = 0;
    int score;

    irest_card = rest_card;
    for (i = 0; i < 4; i++)
    {
        irest_cards[i] = irest_card;
        if (irest_card & 1) irest_card += 16;
        irest_card = irest_card >> 1;
    }

    for (idirection = 0; idirection < 4; idirection++)
       for (icursor = 1; icursor < map_size-1; icursor +=2)
           for (i = 0; i < 4; i++)
    {
        // make the computer more stupid by skipping half of the checks
//        if (random() % 4 < 1)
        {
    
            // copy the map
            memcpy (imap, map, sizeof (map));
            memcpy (iplayer, player, sizeof (player));
    
            // do the imove
            temp = irest_cards[i];
            do_magic_turn (imap, icursor, idirection, temp, iplayer, map_size);
    
            score = get_access_table (access,
               imap, iplayer[current].xco, iplayer[current].yco, map_size);
    
            if (access[iplayer[current].tr_x][iplayer[current].tr_y] != 0)
                score = max_score;
    
            if (score > highest)
            {
                highest = score;
                hdirection = idirection;
                hrest_card = irest_cards[i];
                hcursor = icursor;
            }
        }
    }

    cursor = hcursor;
    direction = hdirection;
    rest_card = hrest_card;
}
/*
  adjusts target to make it reachable.
*/
void adjust_target (map_type &access, int &target_x, int &target_y, int map_size)
{
    int x, y;
    int current, lowest = map_size * 4, low_x = target_x, low_y = target_y;

    for (x = 0; x < map_size; x++)
    {
        for (y = 0; y < map_size; y++)
        {
            current = abs (x - target_x) + abs (y - target_y);
            if ((access[x][y] != 0) && (current < lowest))
            {
                lowest = current;
                low_x = x; low_y = y;
            }
        }
    }
    target_x = low_x;
    target_y = low_y;
}

/*
  changes the access numbers on the route from 1 to target in directions;
*/
void access_to_direction (map_type &access, map_type &map,
    int target_x, int target_y, int map_size)
{
    const int mask [4] = {1, 2, 4, 8};
    const int opposite [4] = {4, 8, 1, 2};

    map_type direction;

    int x, y;

    for (x = 0; x < max_size; x++)
        for (y = 0; y < max_size; y++)
            direction[x][y] = 0;

    x = target_x;
    y = target_y;

    if (access[x][y] == 0) adjust_target (access, x, y, map_size);
        // make more feasible target

    while (access[x][y] != 1)
    {
        int lowest = access[x][y];
        int low_nx = 0, low_ny = 0;
        int dx = 0, dy = -1, swap, dir;
        int nx, ny;

        for (dir = 0; dir < 4; dir ++)
        {
            nx = x + dx; ny = y + dy;

            if ((nx >= 0) && (nx < map_size) &&
                (ny >= 0) && (ny < map_size) &&
                (access[nx][ny] < lowest) &&
                (access[nx][ny] > 0) &&
                (map[x][y] & mask[dir]) &&
                (map[nx][ny] & opposite[dir]))
            {
                direction[nx][ny] = opposite[dir];
                lowest = access[nx][ny];
                low_nx = nx; low_ny = ny;
            }
            swap = -dy; dy = dx; dx = swap; // turn 90 degrees
        }
        x = low_nx; y = low_ny;
    }

    for (x = 0; x < max_size; x++)
        for (y = 0; y < max_size; y++)
            access[x][y] = direction[x][y];
}

void find_way (int current, map_type &direction, map_type &map, players_type &player, int map_size)
{
    get_access_table (direction, map, player[current].xco, player[current].yco, map_size);
    access_to_direction (direction, map, player[current].tr_x, player[current].tr_y, map_size);
}

/*
  initialise treasure for player i.
*/
void init_treasure (int i, players_type player, int map_size)
{
    int x, y, j;
    bool check_ok;

    do {
        x = rand () % map_size;
        y = rand () % map_size;
        check_ok = true;

        // not on the same pos as any player
        for (j = 0; j < player_max; j++)
        {
            if ((x == player[j].xco) && (y == player[j].yco)
                && (player[j].type != UNUSED))
                check_ok = false;
        }

        // not on the same pos as any other treasure
        for (j = 0; j < i; j++)
        {
            if ((x == player[j].tr_x) && (y == player[j].tr_y)
                && (player[j].type != UNUSED)) check_ok = false;
        }

    } while (!check_ok);

    player[i].tr_x = x; player[i].tr_y = y;
}

void initPlayers (players_type player, int map_size)
{
    // initialize the players
    int i;
    for (i = 0; i < player_max; i++)
    {
        player[i].xco = 0;
        player[i].yco = 0;
        player[i].tr_x = 0;
        player[i].tr_y = 0;
        player[i].score = 0;
        player[i].time = 0;
    }
    // put player start pos in corners
    player[3].xco = map_size - 1;
    player[2].yco = map_size - 1;
    player[1].xco = map_size - 1;
    player[1].yco = map_size - 1;

    // init treasure.
    for (i = 0; i < player_max; i++)
    {
        if (player[i].type != UNUSED) init_treasure (i, player, map_size);
    }
}

