#include "hiscore.h"
#include "fstream.h"
#include "JBdraw.h"
#include "hiscore.h"
#include <gstream.h>

#define RELX( x ) (( x ) * buffer->w / 640)
#define RELY( x ) (( x ) * buffer->h / 480)

void HiScore::activate ()
{
    score = 0;
    pos = 0;
    currentplayernr = 0;
    currenttreasures = 0;
    currenttime = 0;
    name[0] = 0;
    isfinished = true;
}

void HiScore::setDefault ()
{
    const char *name[10] =
    {"Jules", "Amarillion", "Wouter", "Annemarie", "Martijn",
     "Shawn", "Arron", "Peter", "George", "Marjan"};
    int i;

    for (i = 0; i < 10; i++)
    {
        strcpy (hiname[i], name[i]);
        hitreasures[i] = i + 1;
        hitime[i] = 20 + 110 * i;
        hiscore[i] = hitreasures[i] * 1000 / hitime[i];
    }
    save();
}

void HiScore::load()
{
    ifstream inhiscorefile ("hiscore.hi", ios::in); 
    if (!inhiscorefile)
    {
        setDefault();
        return;
    } 
    int x=0;
    do {
          inhiscorefile >> hiname[x] >> hitreasures[x] >> hitime[x] >> 
hiscore[x];
          x=x+1;
        }while (x<10);
    inhiscorefile.close(); 
}

void HiScore::save()
{
   ofstream outhiscorefile ("hiscore.hi", ios::out);  
    if (!outhiscorefile)
    {
    cerr << "File could not be saved\n";
    exit(1);
    }
    int x=0;
    do {
          outhiscorefile << hiname[x] <<  ' ' << hitreasures[x] <<  ' ' << hitime[x] <<  ' ' << hiscore[x] << '\n';
          x=x+1;
        }while (x<10);
    outhiscorefile.close(); 
}

void HiScore::sort ()
{
   
   int i, j, swap;
   char hinameswap[31];

     for (i = 0; i < 10; i++)
        for (j = 0; j < i; j++)
            if (hiscore[j] < hiscore[i])
            {
                swap = hiscore[i];
                hiscore[i] = hiscore[j];
                hiscore[j] = swap;
                
                swap = hitreasures[i];
                hitreasures[i] = hitreasures[j];
                hitreasures[j] = swap;

                swap = hitime[i];
                hitime[i] = hitime[j];
                hitime[j] = swap;

                memcpy (hinameswap, hiname[i], 31); // i to swap
                memcpy (hiname[i], hiname[j], 31);  // j to  i
                memcpy (hiname[j], hinameswap, 31); // swap to j
            }

}

void HiScore::outputLine (BITMAP *buffer, int x,  int textline)
{  
    textprintf(buffer, font,
        RELX (96),
        RELY (64+textline+(2*textline)), 5,  hiname[x]);
    textprintf(buffer, font,
        RELX (96 + 30 * 8),
        RELY (64+textline+(2*textline)), 5, "%d", hitreasures[x]);
    textprintf(buffer, font,
        RELX (96 + 42 * 8),
        RELY (64+textline+(2*textline)), 5, "%d", hitime[x]);
    textprintf(buffer, font,
        RELX (96 + 50 * 8),
        RELY (64+textline+(2*textline)), 5, "%d", hiscore[x]);
}

void HiScore::display (BITMAP *buffer, BITMAP *title, BITMAP *panel)
{
     textout_centre(title, font, "HISCORE", title->w / 2, 0, 1);
     int textline; // so we don't print very line on top of eachother
     
     drawbox (buffer, RELX (90), RELX (550), RELY (94), RELY (6), 7);
     textout(buffer, font, "Name", RELX((64+32)), RELY(80), 1);
     textout(buffer, font, "Treasures", RELX((64+32)+(26*8)), RELY(80), 1);
     textout(buffer, font, "Time", RELX((64+32)+(26*8)+(14*8)), RELY(80), 1);
     textout(buffer, font, "Score", RELX((64+32)+(26*8)+(14*8)+(8*8)), RELY(80), 1);
     textline=8;
     int x=0;
     do {
           textline=textline+8;
           outputLine(buffer, x, textline);
            x=x+1;
        }while (x<10);
    textout_centre (buffer, font,
     "Press a key to return to the main menu.", RELX (320), RELY (96 + 296), 1);
}

void HiScore::update ()
{
     int scan, ascii;
     if (!isfinished && keypressed())
     {
         ascii = readkey();
         scan = ascii >> 8;
         ascii &= 0xFF;
         switch (scan)
         {
         case KEY_ESC: case KEY_ENTER:
             isfinished = TRUE;
             name[pos] = 0;
             strcpy (hiname[9], name);
             hitreasures[9] = currenttreasures;
             hitime[9] = currenttime;
             hiscore[9] = score;
             sort ();
             save();
             break;
         case KEY_BACKSPACE: case KEY_DEL:
         case KEY_LEFT:
             if (pos>0) pos--;
             break;
         }
         if ((ascii >= 32) && (ascii < 128))
         {
             if (ascii==32) ascii = '.';
             name[pos] = ascii;
             if (pos < 28) pos++;
         }
         name [pos] = '_';
         name [pos+1] = 0;
     }
}

bool HiScore::finished ()
{
    return isfinished;
}

void HiScore::draw (BITMAP *buffer, BITMAP *title, BITMAP *panel)
{
    textout_centre(title, font, "NEW HI-SCORE", title->w / 2, 0, 1);
    textprintf_centre (buffer, font, RELX(320), RELY(128), 1, "player %d, you got a hi - score", currentplayernr + 1);
    textprintf_centre (buffer, font, RELX(320), RELY(144), 1, "Please enter your name");
    textprintf_centre (buffer, font, RELX(320), RELY(256), 1, name);
}

void HiScore::enter (int playernr, int pscore, int ptime)
{
    if ((ptime > 0) && isfinished)
    {
        score = 1000 * pscore / ptime;
        if (score > hiscore[9])
        { // a new hiscore
            pos = 0;
            name[0] = 0;
            name [pos] = '_';
            name [pos+1] = 0;
            isfinished = FALSE;
            currentplayernr = playernr;
            currenttreasures = pscore;
            currenttime = ptime;
        }
        else
        {
            isfinished = TRUE;
        }
    }
}
