#include <allegro.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "scrshot.h"
#include "3d.h"
#include "game.h"
#include "jbdraw.h"

#define RELX( x ) (( x ) * buffer->w / 640)
#define RELY( x ) (( x ) * buffer->h / 480)

class MagicSeq
{
private:
protected:
    bool isfinished;
public:
    bool finished ();
    virtual void activate ();
    virtual void update ();
};

class MoveSeq
{
private:
protected:
    bool isfinished;
public:
    bool finished ();
    virtual void activate ();
    virtual void update ();
};

void GameEngine::draw_score_box (BITMAP *buffer, int current, int seconds)
{
    const int xpos[4] = {0, RELX(640 - 160), 0, RELX(640 - 160)};
    const int ypos[4] = {0, RELY(480 - 80), RELY(480 - 80), 0};
    const int color[4] = {120, 246, 247, 248};
    int i;

    for (i = 0; i < 4; i++) if (player[i].type != UNUSED)
    {
        BITMAP *temp = create_sub_bitmap (buffer, xpos[i], ypos[i],
            RELX(160), RELY(80));
        clear_to_color (temp, (i == current) ? color[i] : 243);
        if (i == current)
        {
            doubleprintf_centre (temp, font,
                RELX(80), RELY(8), 245, 241,
                "It is your turn...");
        }
        doubleprintf_centre (temp, font,
            RELX(80), RELY(24), 245, 241,
            "Score : %d", player[i].score);
        doubleprintf_centre (temp, font,
            RELX(80), RELY(48), 245, 241,
            "Time : %d",
            (i == current) ? player[i].time + seconds : player[i].time);
        destroy_bitmap (temp);
    }
}

bool GameEngine::getHasEscaped ()
{
    return has_escaped;
}

int GameEngine::getMapSize ()
{
    return map_size;
}

void GameEngine::setPlayerType (int index, int newType)
{
    player[index].type = newType;
}

void GameEngine::setMapSize (int newsize)
{
    map_size = newsize;
}

int GameEngine::getPlayerType (int index)
{
    return player[index].type;
}

int GameEngine::getPlayerTreasures (int index)
{
    return player[index].score;
}

int GameEngine::getPlayerTime (int index)
{
    return player[index].time;
}

bool GameEngine::finished()
{
    return quit;
}

int GameEngine::init (DATAFILE *data)
{
    char buffer[80];

    texture = create_bitmap (512, 512);
    clear_bitmap (texture);
    int i;
    for (i = 0; i < 16; i++)
    {
        sprintf (buffer, "MAZE%03d", i);
        maze_bmp[i] = reinterpret_cast< BITMAP* >
            (find_datafile_object (data, buffer)->dat);
        if (!maze_bmp[i])
        {
            allegro_message ("Data file corrupted, could not find bitmap");
            return 0; // error message
        }
        //maze_bmp[i] = (BITMAP*)data[MAZE000+i].dat;
    }
    for (i = 0; i < 8; i++)
    {
        sprintf (buffer, "PUP%03d", i);
        rlePup[i] = reinterpret_cast< RLE_SPRITE* >
            (find_datafile_object (data, buffer)->dat);
        if (!rlePup[i])
        {
            allegro_message ("Data file corrupted, could not find bitmap");
            return 0; // error message
        }
    }
    palette = reinterpret_cast<RGB*>
        (find_datafile_object(data, "PALETTE")->dat);
    if (!palette)
    {
        allegro_message ("Data file corrupted, could not find palette");
        return 0; // error message
    }
    donkey = reinterpret_cast<SAMPLE*>
        (find_datafile_object(data, "DONKEY")->dat);
    if (!donkey)
    {
        allegro_message ("Data file corrupted, could not find sample");
        return 0;
    }
    return 1;
}

void GameEngine::setTreasureLimit (int newLimit)
{
    treasure_limit = newLimit;
}

int GameEngine::getTreasureLimit ()
{
    return treasure_limit;
}

void GameEngine::exit ()
{
    destroy_bitmap(texture);
}

void GameEngine::activate ()
{
    quit = false;
    sq_next = 0;

    text_mode (-1);
    init_3D (map_size);

    set_palette (palette);

    has_escaped = FALSE;
    messager.setRect (SCREEN_W / 4, 0, SCREEN_W / 2, SCREEN_H);
    messager.activate();
}

void GameEngine::update (int msec)
{
    currentmsec = msec;
    if (!quit) {
       if (do_animation() == 0)
       {
           sq_this = sq_next;
           do_sequence (quit);
       }
       process_input();
       particle.update();
       messager.update();
    }
}

void GameEngine::draw (BITMAP *buffer)
{
    clear_bitmap (buffer);
    particle.draw (buffer);
    render(buffer, texture);
    draw_score_box (buffer, current_player, (currentmsec-start)/1000);
    messager.draw (buffer);

//    stretch_blit (texture, buffer, 0, 0, texture->w, texture->h,
//        buffer->w - 100, buffer->h - 100, 100, 100);
}

/*
  init_game : new game initialisation (random map, etc)
*/
void GameEngine::init_game(map_type &map, int &rest_card)
{
    initMap (map, rest_card, map_size);
    initPlayers (player, map_size);
}

void GameEngine::draw_map (const map_type &map)
{
    int x, y;
    for (x = 0; x < map_size; x++)
        for (y = 0; y < map_size; y++)
            draw_sprite (texture, maze_bmp[map[x][y]], x * 48, y * 48);
}

void GameEngine::draw_card (int rest_card)
{
    draw_sprite (texture, maze_bmp[rest_card], 512 - 48, 512 - 48);
}

void GameEngine::draw_players (int current_player, players_type player)
{
    int i;
    for (i = 0; i < player_max; i++) if (player[i].type != UNUSED)
    {
        draw_rle_sprite (texture, rlePup[i + 4],
            player[i].xco * 48 + 16, player[i].yco * 48 + 16);
        draw_rle_sprite (texture, rlePup[i],
            player[i].tr_x * 48 + 16, player[i].tr_y * 48 + 16);
    }
}

/*
  represent access table visually
*/
void GameEngine::draw_access_table (map_type &access)
{
    int x, y;

    for (x = 0; x < map_size; x++)
        for (y = 0; y < map_size; y++)
        {
            textprintf_centre (texture, font,
                x * 48 + 24, y * 48 + 24, 100, "%d", access[x][y]);
        }
}

void GameEngine::get_card_pos (int cursor, int direction, int &xco, int &yco)
{
    switch (direction)
    {
    case 0: xco = cursor * 48; yco = -48; break;
    case 1: xco = map_size * 48; yco = cursor * 48; break;
    case 2: xco = cursor * 48; yco = map_size * 48; break;
    case 3: xco = -48; yco = cursor * 48; break;
    }
}

void GameEngine::get_corner_pos (int direction, int &xco, int &yco)
{
    switch (direction)
    {
    case 0: xco = -48; yco = -48; break;
    case 1: xco = map_size * 48; yco = -48; break;
    case 2: xco = map_size * 48; yco = map_size * 48; break;
    case 3: xco = -48; yco = map_size * 48; break;
    }
}

void GameEngine::prepare_split (map_type &map, int rest_card, int &direction, int &cursor)
{
    switch (direction)
    {
    case 0:
        blit (texture, texture,
            cursor * 48, 0,
            512 - 48, 512 - 48 * map_size,
            48, map_size * 48);
        draw_sprite (texture, maze_bmp[rest_card], 512 - 48,
            512 - 48 * map_size - 48);
        make_split (cursor * 48, map_size * 48,
            (cursor + 1) * 48, 0,
            (map_size - cursor - 1) * 48, map_size * 48,
            48, (map_size + 1) * 48,
            cursor * 48, -48);
        board_move_to (2, cursor * 48, 0, 20);
        break;
    case 2:
        blit (texture, texture,
            cursor * 48, 0,
            512 - 48, 512 - 48 * map_size - 48,
            48, map_size * 48);
        draw_sprite (texture, maze_bmp[rest_card], 512 - 48, 512 - 48);
        make_split (cursor * 48, map_size * 48,
            (cursor + 1) * 48, 0,
            (map_size - cursor - 1) * 48, map_size * 48,
            48, (map_size + 1) * 48,
            cursor * 48, 0);
        board_move_to (2, cursor * 48, -48, 20);
        break;
    case 1:
        blit (texture, texture,
            0, cursor * 48,
            512 - 48 * map_size - 48, 512 - 48,
            map_size * 48, 48);
        draw_sprite (texture, maze_bmp[rest_card], 512 - 48, 512 - 48);
        make_split (map_size * 48, cursor * 48,
            0, (cursor + 1) * 48,
            map_size * 48, (map_size - cursor - 1) * 48,
            (map_size + 1) * 48, 48,
            0, cursor * 48);
        board_move_to (2, -48, cursor * 48, 20);
        break;
    case 3:
        blit (texture, texture,
            0, cursor * 48,
            512 - 48 * map_size, 512 - 48,
            map_size * 48, 48);
        draw_sprite (texture, maze_bmp[rest_card],
            512 - map_size * 48 - 48, 512 - 48);
        make_split (map_size * 48, cursor * 48,
            0, (cursor + 1) * 48,
            map_size * 48, (map_size - cursor - 1) * 48,
            (map_size + 1) * 48, 48,
            -48, cursor * 48);
        board_move_to (2, 0, cursor * 48, 20);
        break;
    }
}

int pup_x, pup_y, pup_ex, pup_ey, pup_type, pup_dx, pup_dy;

bool GameEngine::animating_pup (map_type &map, int current)
{
    draw_map (map);
    int i;
    pup_x += pup_dx * 4;
    pup_y += pup_dy * 4;
    for (i = 0; i < player_max; i++)
        if ((player[i].type != UNUSED) && (i != current))
    {
        draw_rle_sprite (texture, rlePup[i+4],
            player[i].xco * 48 + 16, player[i].yco * 48 + 16);
        draw_rle_sprite (texture, rlePup[i],
            player[i].tr_x * 48 + 16, player[i].tr_y * 48 + 16);
    }
    draw_rle_sprite (texture, rlePup[current + 4],
        pup_x + 16, pup_y + 16);
    draw_rle_sprite (texture, rlePup[current],
        player[current].tr_x * 48 + 16, player[current].tr_y * 48 + 16);

    if ((pup_y == pup_ey) && (pup_x == pup_ex))
    {
        player[current].xco += pup_dx;
        player[current].yco += pup_dy;
        return TRUE;
    }
    else return FALSE;
}

// dx -1, 1, 0
void GameEngine::animate_pup (int current, int dx, int dy)
{
    pup_x = player[current].xco * 48;
    pup_y = player[current].yco * 48;
    pup_dx = dx;
    pup_dy = dy;
    pup_ex = pup_x + 48 * dx;
    pup_ey = pup_y + 48 * dy;
    sq_next = 21;
}


void GameEngine::do_sequence (bool &quit)
{
    static int cursor, direction;
    static int rest_card;
    static map_type map;
    static map_type dirmap;
    int x, y, command;

//    textprintf_right (buffer, font, 640, 0, 100, "%d", rest_card);

    if ((key[KEY_ESC]) && (sq_this < 60))
    {
        sq_next = 60;
        has_escaped = TRUE;
    }

    switch (sq_this)
    {
    case 0: // start game
        srand(time(0));
        init_game (map, rest_card);
        particle.init();
        draw_map (map);
        current_player = 0;
        draw_players (current_player, player);
        make_board (map_size * 48);
        swap_board_in (50);
        camera_rotate_to (0, 50);
        sq_next = 1;
        break;
    case 1: // start turn
        start = currentmsec;
        if (player[current_player].type == HUMAN)
            sq_next = 5;
        else
            sq_next = 2;
        break;
    case 2: // start computer magic
        messager.setMessage (3);
        comp_magic_turn (map, cursor, direction, rest_card, current_player, player, map_size);
        draw_card (rest_card);
        make_card (48, 0, 0);
        get_card_pos (cursor, direction, x, y);
        swap_card_in (x, y, 20);
        sq_next = 10;
        break;
    case 5: // start human magic
        messager.setMessage (1);
        cursor = 1;
        direction = 0;
        draw_card (rest_card);
        make_card (48, 0, 0);
        get_card_pos (cursor, direction, x, y);
        swap_card_in (x, y, 20);
        sq_next = 6;
        break;
    case 6:
        command = 0;
        if (key[KEY_RIGHT])
        {
            if (direction < 2) cursor += 2; else cursor -= 2;
            if ((cursor >= map_size) || (cursor < 0))
            {
                if (++direction >= 4) direction = 0;
                get_corner_pos (direction, x, y);
                board_move_to (2, x, y, 10);
                sq_next = 8;
                cursor = ((direction == 0) || (direction == 1))
                    ? 1 : map_size-2;
            } else {
                get_card_pos (cursor, direction, x, y);
                board_move_to (2, x, y, 10);
            }
            break;
        }
        if (key[KEY_LEFT])
        {
            if (direction < 2) cursor -= 2; else cursor += 2;
            if ((cursor >= map_size) || (cursor < 0))
            {
                get_corner_pos (direction, x, y);
                board_move_to (2, x, y, 10);
                sq_next = 8;
                if (--direction < 0) direction = 3;
                cursor = ((direction == 0) || (direction == 1))
                    ? map_size-2 : 1;
            } else {
                get_card_pos (cursor, direction, x, y);
                board_move_to (2, x, y, 10);
            }
            break;
        }
        if (key[KEY_UP])
        {
            if (rest_card & 1) rest_card += 16;
            rest_card = rest_card >> 1;
            board_rotate_to (2, -64, 10);
            sq_next = 7;
            break;
        }
        if (key[KEY_DOWN])
        {
            rest_card = rest_card << 1;
            if (rest_card >= 16) rest_card -= 15;
            board_rotate_to (2, 64, 10);
            sq_next = 7;
            break;
        }
        if (key[KEY_ENTER])
        {
            sq_next = 10;
            break;
        }
        break;
    case 7: // do a turn
        draw_card (rest_card);
        get_card_pos (cursor, direction, x, y);
        make_card (48, x, y);
        sq_next = 6;
        break;
    case 8:
        get_card_pos (cursor, direction, x, y);
        board_move_to (2, x, y, 10);
        sq_next = 6;
        break;
    case 10: // slide card in maze
        prepare_split (map, rest_card, direction, cursor);
        sq_next = 11;
        break;
    case 11:
        do_magic_turn (map, cursor, direction, rest_card, player, map_size);
        direction = (direction + 2) % 4;
        draw_map (map);
        draw_players (current_player, player);
        draw_card (rest_card);
        get_card_pos (cursor, direction, x, y);
        make_board (map_size * 48);
        make_card (48, x, y);
        swap_card_out (10);
        sq_next = 19;
        break;
    case 19:
        messager.setMessage (0);
        sq_next = 20;
        break;
    case 20: // move turn
        if (player[current_player].type == COMPUTER)
            find_way (current_player, dirmap, map, player, map_size);
        else
            messager.setMessage (2);

        command = -2;

        if (player[current_player].type == HUMAN)
        {
            command = -2;
            if (key[KEY_DOWN]) command = SOUTH;
            if (key[KEY_UP]) command = NORTH;
            if (key[KEY_LEFT]) command = WEST;
            if (key[KEY_RIGHT]) command = EAST;
            if (key[KEY_ENTER]) command = 0;
        }
        else
        {
           command = dirmap[player[current_player].xco]
                           [player[current_player].yco];
        }

        switch (command)
        {
        case 0:
            sq_next = 50;
            break;
        case WEST:
            if ((player[current_player].xco > 0) &&
                (map[player[current_player].xco][player[current_player].yco] & WEST) &&
                (map[player[current_player].xco-1][player[current_player].yco] & EAST))
                animate_pup (current_player, -1, 0);
            break;
        case EAST:
            if ((player[current_player].xco < map_size-1) &&
                (map[player[current_player].xco][player[current_player].yco] & EAST) &&
                (map[player[current_player].xco+1][player[current_player].yco] & WEST))
                animate_pup (current_player, 1, 0);
            break;
        case NORTH:
            if ((player[current_player].yco > 0) &&
                (map[player[current_player].xco][player[current_player].yco] & NORTH) &&
                (map[player[current_player].xco][player[current_player].yco-1] & SOUTH))
                animate_pup (current_player, 0, -1);
            break;
        case SOUTH:
            if ((player[current_player].yco < map_size-1) &&
                (map[player[current_player].xco][player[current_player].yco] & SOUTH) &&
                (map[player[current_player].xco][player[current_player].yco+1] & NORTH))
                animate_pup (current_player, 0, 1);
            break;
        }
        if ((player[current_player].xco == player[current_player].tr_x) &&
            (player[current_player].yco == player[current_player].tr_y))
        {
            sq_next = 22;
            player[current_player].score++;
            if (player[current_player].score == treasure_limit)
                sq_next = 60;
            init_treasure (current_player, player, map_size);
            draw_map (map);
            draw_players (current_player, player);
            play_sample (donkey, 255, 128, 1000, FALSE);
        }
        break;
    case 21:
        if (animating_pup (map, current_player))
            sq_next = 20;
        break;
    case 22:
//        camera_rotate_to (0, 20);
        sq_next = 50;
        break;
    case 50: // next player
        ticks = currentmsec - start;
        player[current_player].time += ticks / 1000;
        do {
            if (++current_player >= player_max) current_player = 0;
        } while (player[current_player].type == UNUSED);
        sq_next = 1;
        break;
    case 60: // einde spel
        sq_next = 61;
        swap_board_out (20);
        break;
    case 61:
        quit = TRUE;
        break;
    }
    if (key[KEY_F1]) screenshot ();
}

