#ifndef GAME_H
#define GAME_H

#include <allegro.h>
#include <time.h>
#include "particle.h"
#include "msg.h"
#include "maze_ai.h"

const int NORTH = 1, EAST = 2, SOUTH = 4, WEST = 8;

class GameEngine
{
private:
    BITMAP* maze_bmp[16];
    RLE_SPRITE* rlePup[8];
    BITMAP *texture;
    SAMPLE *donkey;
    RGB *palette;
    Particle particle;
    players_type player;
    bool quit;
    int sq_this ;
    int sq_next;
    Messager messager;
    int treasure_limit;
    int map_size;
    bool has_escaped;
    int start;
    int ticks;
    int currentmsec;
    int current_player;
    void init_game (map_type &map, int &rest_card);
    void draw_map (const map_type &map);
    void draw_card (int rest_card);
    void draw_players (int current_player, players_type player);
    void draw_access_table (map_type &access);
    void get_card_pos (int cursor, int direction, int &xco, int &yco);
    void get_corner_pos (int direction, int &xco, int &yco);
    void prepare_split (map_type &map, int rest_card, int &direction, int &cursor);
    bool animating_pup (map_type &map, int current);
    void animate_pup (int current, int dx, int dy);
    void do_sequence (bool &quit);
    void draw_score_box (BITMAP *buffer, int current, int seconds);
public:
    bool getHasEscaped ();
    int getMapSize ();
    void setMapSize (int newMapSize);
    void setTreasureLimit (int newLimit);
    int getTreasureLimit ();
    void setPlayerType (int index, int newType);
    int getPlayerType (int index);
    int getPlayerTreasures (int index);
    int getPlayerTime (int index);
    bool finished();
    int init (DATAFILE *data);
    void exit ();
    void activate ();
    void update (int msec);
    void draw (BITMAP *buffer);
};

#endif
