#include "resources.h"
#include <assert.h>
#include "anim.h"
#include <tegel.h>
#include "levelset.h"
#include "cutscene.h"
#include "dom.h"

using namespace std;
using namespace xdom;

#ifndef PI
#define PI 3.1415926
#endif

// adds all filenames that match pattern to the vector
void glob(const char *pattern, vector<string> &result)
{
	char buf[1024];
	
	al_ffblk info;
	
	int temp = al_findfirst (pattern, &info, FA_RDONLY | FA_ARCH);
	
	while (temp == 0)
	{
		replace_filename(buf, pattern, info.name, sizeof(buf));
		result.push_back (std::string(buf));
		temp = al_findnext(&info);
	}
			
	al_findclose(&info);
}

void Resources::makeHitAnim (char *id, char *id2)
{
	RLE_SPRITE * s = getRle (id);	
	BITMAP *temp = create_bitmap (s->w, s->h);
	clear_to_color (temp, makecol (255, 0, 255));
	draw_rle_sprite (temp, s, 0, 0);
	int x, y;
	for (x = 0; x < s->w; ++x)
		for (y = 0; y < s->h; ++y)
			if (getpixel (temp, x, y) != makecol (255, 0, 255)) 
				putpixel (temp, x, y, makecol (255, 255, 255));
	RLE_SPRITE *temp_rle = get_rle_sprite (temp);
	destroy_bitmap (temp);
	generated.push_back (temp_rle);
	Frame f;
	f.rle = temp_rle;
	f.time = 0;
	Anim *a = new Anim();
	a->add (f);
	animlist.insert (pair<string, Anim*>(id2, a));	
}

int Resources::init()
// returns 1 on succes, 0 on failure
{
	// load all .dat files in data directory
	vector <string> datafilenames;
	glob ("data/*.dat", datafilenames);
	for (vector<string>::iterator i = datafilenames.begin();
		i != datafilenames.end(); ++i)
	{
		DATAFILE *temp;
		if (!(temp = teg_load_datafile (i->c_str())))
		{ 
			return 0;
		} else {
				data.push_back (temp);
		}
	}

	TEG_MAP *tempmap;
	if (!(tempmap = teg_loadmap ("data/level1.map", getTilelist ("ASET"))))
	{
		return 0;
	} else {
			maps.push_back (tempmap);
			maplist.insert (pair<string, TEG_MAP*>("level1", tempmap));
	}
	if (!(tempmap = teg_loadmap ("data/level2.map", getTilelist ("ASET"))))
	{
		return 0;
	} else {
			maps.push_back (tempmap);
			maplist.insert (pair<string, TEG_MAP*>("level2", tempmap));
	}
	if (!(tempmap = teg_loadmap ("data/level3.map", getTilelist ("ASET"))))
	{
		return 0;
	} else {
			maps.push_back (tempmap);
			maplist.insert (pair<string, TEG_MAP*>("level3", tempmap));
	}
	
	if (!(tempmap = teg_loadmap ("data/bg1.map", getTilelist ("BG"))))
	{
		return 0;
	} else {
			maps.push_back (tempmap);
			maplist.insert (pair<string, TEG_MAP*>("bg1", tempmap));
	}
	
	// load xml data
	
	DomNode node = xmlParseFile("data/levels.xml");
	
	vector<DomNode>::iterator n;
	for (n = node.children.begin(); n != node.children.end(); ++n)
	{
		if (n->name == "anim")
		{
			Anim::loadFromXml (&(*n), this, animlist);
		}
		else if (n->name == "levelset")
		{
			Levelset::loadFromXml (&(*n), this, levelsets);
		}
		else if (n->name == "cutscene")
		{
			CutScene::loadFromXml (&(*n), this, cutscenes);
		}
	}	
	return 1;
}

Resources::~Resources()
{
	{
		map<string, Anim*>::iterator i;
		for (i = animlist.begin(); i != animlist.end(); i++)
		{
			delete (i->second);
		}
	}
	{
		vector<DATAFILE*>::iterator i;
		for (i = data.begin(); i != data.end(); ++i)
		{
				teg_unload_datafile (*i);
				*i = NULL;
		}
	}
}

FONT *Resources::getFont (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_FONT)
					temp = NULL;
	}
	if (temp)
			return (FONT*)temp->dat;
	else
			return NULL;	
}

RLE_SPRITE *Resources::getRle (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_RLE_SPRITE)
					temp = NULL;
	}
	if (temp)
			return (RLE_SPRITE*)temp->dat;
	else
			return NULL;
}

SAMPLE *Resources::getSample (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_SAMPLE)
					temp = NULL;
	}
	if (temp)
			return (SAMPLE*)temp->dat;
	else
			return NULL;
}

ALSPC_DATA *Resources::getSPC (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_ALSPC)
					temp = NULL;
	}
	if (temp)
			return (ALSPC_DATA*)temp->dat;
	else
			return NULL;
}

Anim *Resources::getAnim (string id)
{
	assert (animlist.find (id) != animlist.end());
	return animlist[id];
}

Levelset *Resources::getLevelset (string id)
{
	assert (levelsets.find (id) != levelsets.end());
	return levelsets[id];
}

CutScene *Resources::getCutScene (string id)
{
	assert (cutscenes.find (id) != cutscenes.end());
	return cutscenes[id];
}

TEG_MAP *Resources::getMap (string id)
{
	assert (maplist.find (id) != maplist.end());
	return maplist[id];
}

TEG_TILELIST *Resources::getTilelist (string id)
{
	vector<DATAFILE*>::iterator i;
	DATAFILE *temp = NULL;
	for (i = data.begin(); i != data.end() && temp == NULL; ++i)
	{
			assert (*i);
			temp = find_datafile_object (*i, id.c_str());				
			// check if object is of the right type
			if (temp && temp->type != DAT_TEG_TILELIST)
					temp = NULL;
	}
	if (temp)
			return (TEG_TILELIST*)temp->dat;
	else
			return NULL;
}
