#include "cutscene.h"
#include <tegel.h>
#include <string>
#include "resources.h"
#include <assert.h>

using namespace std;
using namespace xdom;

void CutScene::init()
{
	currentParagraph = 0;
	enter_pressed = false;
	finished = false;
	timer = 10;
}

void CutScene::draw (BITMAP *buffer)
{
	clear_bitmap (buffer);
	
	int x = 160, y = 100;
	
	rectfill (buffer, 24, 24, 304, 84, GREY);
	rectfill (buffer, 20, 20, 300, 80, makecol (0, 0, 64));
	rect (buffer, 20, 20, 300, 80, BLUE);
	draw_rle_sprite (buffer, rle, (320 - rle->w) / 2, (100 - rle->h) / 2);
	string p = paragraphs[currentParagraph];
	unsigned int pos = 0;
	unsigned int newpos;
	while ((newpos = p.find('\n', pos)) != string::npos)
	{
		textprintf_centre_ex (buffer, font, 
			x+1, y+1, GREY, -1, "%s", (string(p, pos, newpos - pos)).c_str());
		textprintf_centre_ex (buffer, font, 
			x, y, WHITE, -1, "%s", (string(p, pos, newpos - pos)).c_str());
		y += 16;
		pos = newpos + 1;
	}
	textprintf_centre_ex (buffer, font, 
		x+1, y+1, GREY, -1, "%s", (string(p, pos)).c_str());
	textprintf_centre_ex (buffer, font, 
		x, y, WHITE, -1, "%s", (string(p, pos)).c_str());
	
}

void CutScene::update ()
{
	if (timer > 0)
	{
		timer--;
	}
	else
	{
		if (key[KEY_ENTER] && !enter_pressed)
		{
			if (currentParagraph < (signed int)(paragraphs.size()) - 1)
			{
				currentParagraph++;
				timer = 10;
			}
			else
			{
				finished = true;
			}
		}
		if (key[KEY_ESC])
		{
			finished = true;
		}
	}
	enter_pressed = key[KEY_ENTER];
}

int CutScene::loadFromXml (DomNode *n, Resources *res, map<string, CutScene*> &result)
{
	assert (n->name == "cutscene");
	string name = n->attributes["name"];
	
	CutScene *temp = new CutScene;
	temp->rle = res->getRle(n->attributes["rle"]);
	vector<DomNode>::iterator i;
	for (i = n->children.begin(); i != n->children.end(); ++i)
	{
		if (i->name == "p")
		{
			temp->paragraphs.push_back (i->cdata[0]);
		}
	}	
	result.insert (pair<string, CutScene*>(name, temp));
	return 1;
}
