#ifndef OBJECT_H
#define OBJECT_H

#include <allegro.h>
#include <list>
#include "tegel.h"

using namespace std;


// tile stack properties
#define TS_SOLID 0x01
#define TS_SOFT 0x04
#define TS_BRIDGE 0x08

// object types
#define OT_NOT_SPECIFIED 0x00
#define OT_MONSTER 0x01
#define OT_PLAYER 0x02
#define OT_EXIT 0x03
#define OT_BULLET 0x04

class Objects;
class Engine;
class Anim;
class Resources;

// in this class,
// current is not guaranteed to be set.
// parent is not guaranteed to be set,
// although it should be when the first update / draw is called.
class Object
{
private:
	int frame;
	int animcounter;	

	fix z;
	int level;
	fix x, y;
	Anim *current;
	
protected:

	int hasGravity;
	int sprdx, sprdy;
	int w, h;
	bool solid;
	bool alive;
	bool visible;
	void setAnim (Anim *a);
	Resources *getResources();
	Objects* parent;

	void kill () { alive = false; }
	int getTileStackFlags(int mx, int my);
public:
	// public only for debugging
	fix jump_dy;
	int supportType;

	Object ();
	void setParent (Objects *p);
	
	//fixed getShadowX();
	
	//bool isWalking(); // walking or flying?
	bool isSolid() { return solid; } // can collide with other stuff?
	bool isVisible() { return visible; } // to be drawn?
	//bool hasShadow(); // draw a shadow?
	bool isAlive() { return alive; } // if not, scheduled to be killed
	//virtual int getType();
	//virtual int getClass();
	
		
	RLE_SPRITE *getSprite ();
	
	TEG_MAP *getMap();
	void try_move (fix dx, fix dy);
	virtual void setLocation (fix nx, fix ny);
	int getSprx () { return x + sprdx; }
	int getSpry () { return y + sprdy; }
	fix getx () { return x; }
	fix gety () { return y; }
	int getw () { return w; }
	int geth () { return h; }
	virtual void update();
	int getLevel () { return level; }
	virtual int getType () { return OT_NOT_SPECIFIED; }
	virtual void handleCollission(Object *o) {}
};

class Objects
{
private:
	Engine *parent;
	list <Object*> objects;
public:
	Objects (Engine *p) { parent = p; }
	Engine *getParent() { return parent; }
	void add(Object *o);
	void update();
	void killAll();
	void draw (BITMAP *buffer, int xofst, int yofst);
	int size() { return objects.size(); }; // returns # of objects
};

#endif
