#include <allegro.h>
#include "testview.h"
#include "resources.h"
#include <map>
#include "engine.h"
#include "anim.h"

void Testview::update ()
{
	framecounter += 25;
	if (key[KEY_UP])
	{
		y_pos--;
	}
	if (key[KEY_DOWN])
	{
		y_pos++;
	}
}

void Testview::draw (BITMAP *buffer)
{
	Resources *res;
	res = parent->getResources();
	clear_bitmap (buffer);
	
	int x, y, minh;
	x = 5; y = 5; minh = 0;
	
	RLE_SPRITE *s;
	
	map<string, Anim*>::iterator i;
	for (i = res->animlist.begin(); i != res->animlist.end(); ++i)
	{
		Anim *a = i->second;
		int length = a->getTotalLength();
		int frame = 0;
		int remain = 0;
		if (length > 0) remain = framecounter % length;
		while (remain > a->getFrameTime(frame)
			&& frame < (a->getFrameCount()-1))
		{
			remain -= a->getFrameTime(frame);
			frame++;
		}
		s = a->getFrameRle (frame);
		draw_rle_sprite (buffer, s, x, y - y_pos);
		//~ textprintf_ex (buffer, font, x, y, makecol (255, 255, 255), -1, "%s", i->first.c_str());
		
		x += s->w + 10;
		if (minh < s->h) minh = s-> h;
		if (x > 300)
		{
			y += minh + 10;
			x = 5;
			minh = 0;
		}
	}
}
