#include "menu.h"
#include "main.h"
#include <math.h>

Menu::Menu(Main *p) : blinkSpeed (4)
{
	isResume = false;
	subMenu = false;
	waitForKey = false;
	parent = p;
	blinkTimer = 0;
}

Menu::~Menu()
{
}

int Menu::getMenuItemCount()
{
	if (!subMenu)
	{
		if (parent->isCheatUnlocked())
		{
			return 4;
		}
		else
		{
			return 3;
		}
	}
	else
	{
		return 7;
	}	
}

void Menu::draw (BITMAP *buffer)
{
	clear_to_color (buffer, BLACK);
	draw_rle_sprite (buffer, logo, (buffer->w - logo->w) / 2, 20);
	draw_rle_sprite (buffer, fole, fole_x, fole_y);
	int i;
	for (i = 0; i < getMenuItemCount(); i++)
	{
		int color = CYAN;
		if (i == cursor) color = (waitForKey && blinkTimer < 0) ? YELLOW : RED;
		textprintf_centre_ex (buffer, myfont, buffer->w / 2,
			i * (subMenu ? 16 : 30) + 100, color, -1, getMenuItem (i).c_str());
	}				
	textprintf_centre_ex (buffer, myfont, buffer->w / 2,
		232, GREY, -1, getHint (cursor).c_str());
}

void Menu::update()
{
	if (++blinkTimer > blinkSpeed) blinkTimer = -blinkSpeed;
	
	fole_phase += 0.03;
	fole_x = 152 + (int)(40 * cos(fole_phase / 2));
	fole_y = fole_target_y + (int)(10 * cos(fole_phase * 3));
	int temp = cursor * (subMenu ? 16 : 30) + 100 - 4;
	if (fole_target_y < temp) { fole_target_y += 2; }
	if (fole_target_y > temp) { fole_target_y -= 2; }
	
	if (!waitForKey)
	{
		if (keypressed())
		{
			switch (readkey() >> 8)
			{
				case KEY_ENTER: case KEY_SPACE:
				doMenuItem (cursor);	   
				break;
				case KEY_UP: case KEY_LEFT:
				cursor--;
				parent->playSample (blip);
				if (cursor < 0) cursor = getMenuItemCount() - 1;
				break;					
				case KEY_RIGHT: case KEY_DOWN: case KEY_TAB:
				cursor++;
				parent->playSample (blip);
				if (cursor >= getMenuItemCount()) cursor = 0;
				break;					
				case KEY_ESC:
				state = 0;
				break;					
			}
		}
	}
	else
	{
		int c = getLastScancode();
		if (c != 0)
		{	
			clear_keybuf();
			if (c == KEY_ESC)
			{
			}
			else
			{
				switch (cursor)
				{
					case 1:
						parent->getButton()[btnLeft].setScancode(c);
						set_config_int ("xelda", "key_left", c);
						break;
					case 2:
						parent->getButton()[btnRight].setScancode(c);
						set_config_int ("xelda", "key_right", c);
						break;
					case 3:
						parent->getButton()[btnDown].setScancode(c);
						set_config_int ("xelda", "key_down", c);
						break;
					case 4:
						parent->getButton()[btnAction].setScancode(c);
						set_config_int ("xelda", "key_action", c);
						break;
					case 5:
						parent->getButton()[btnJump].setScancode(c);
						set_config_int ("xelda", "key_jump", c);
						break;
					default:
						assert (false);
						break;
				}
			}
			waitForKey = false;
		}
	}
}

void Menu::init()
{ 
	myfont = font;
	fole = parent->getResources()->getRle ("fole");
	logo = parent->getResources()->getRle ("logo");
	miau = parent->getResources()->getSample ("ought");
	blip = parent->getResources()->getSample ("blip");
	
	fole_x = -100;
	fole_y = 120;
	fole_target_y = 120;
	fole_phase = 0.0;
}

string Menu::getHint(int i)
{
	if (!subMenu)
	{
		return string ("");
	}
	else
	{
		switch (i)
		{
			case 0:
				return string ("press enter to turn sound on or off");
				break;
			case 1: case 2: case 3: case 4: case 5:
				if (!waitForKey)
					return string ("press enter to change key");
				else
					return string ("press a new key or esc to cancel");
				break;
			case 6:
				return string ("press enter to return to main menu");
				break;			
			default:
				assert (false);
				break;
		}
	}
}

string Menu::getMenuItem(int i)
{
	if (!subMenu)
	{
		switch (i)
		{
			case 0:
				if (!isResume)
					return string ("Start game");
				else
					return string ("Resume game");
				break;
			case 1:
				return string ("Quit");
			case 2:
				return string ("Settings");
				break;			
			case 3:
				if (parent->isCheatOn())
					return string ("Cheat is on");
				else
					return string ("Cheat is off");
				break;			
			default:
				assert (false);
		}		
	}
	else
	{
		switch (i)
		{
			case 0:
				if (parent->isSoundOn())
					return string ("Sound is on");
				else
					return string ("Sound is off");
				break;
			case 1: 
				return string ("left: [" + string (parent->getButton()[btnLeft].name()) + "]");
				break;
			case 2: 
				return string ("right: [" + string (parent->getButton()[btnRight].name()) + "]");
				break;
			case 3: 
				return string ("down: [" + string (parent->getButton()[btnDown].name()) + "]");
				break;
			case 4: 
				return string ("action: [" + string (parent->getButton()[btnAction].name()) + "]");
				break;
			case 5:
				return string ("jump: [" + string (parent->getButton()[btnJump].name()) + "]");
				break;
			case 6:
				return string ("return");
				break;
			default:
				assert (false);	
		}		
	}
}

void Menu::doMenuItem(int i)
{
	if (!subMenu)
	{
		switch (i)
		{
			case 0: // start game
				if (isResume) state = 2; else state = 1;
				break;
			case 1:
				state = 0;
				break;
			case 2:
				subMenu = true;
				cursor = 0;
				break;			
			case 3:
				parent->setCheatOn (!parent->isCheatOn());			
				break;
			default:
				assert (false);
		}	  
	}
	else
	{
		switch (i)
		{
			case 0:
				parent->setSoundOn (!parent->isSoundOn());			
				break;			
			case 1: case 2: case 3: case 4: case 5:
				waitForKey = true;
				resetLastScancode(); // start monitoring scancode
				break;
			case 6: // return to main menu
				subMenu = false;
				cursor = 2;
				break;
			default:
				assert (false);
		}
	}	
}

void Menu::initStart()
{
	isResume = false;
	state = -1;
	parent->playMusic ("MMENU");
	cursor = 0;
	clear_keybuf();
}

void Menu::initResume()
{
	isResume = true;
	state = -1;
	parent->playMusic ("MMENU");
	cursor = 0;
	clear_keybuf();
}


