#ifndef MONSTER_H
#define MONSTER_H

#include "object.h"

#define EXITOBJECT_NORMAL_NUM 4
#define MONSTER_NORMAL_NUM 3

class ExitObject : public Object
{
	public:
	enum ExitType {DONUT, HASH, TEDDY, PRINCESS};
	
	private:
	
	bool isfound;
	static SAMPLE *blip;
	static Anim *normal[EXITOBJECT_NORMAL_NUM];
	ExitType exitObjectType;
	
	public:
	ExitObject(ExitType type);
	static void init(Resources *res);
	virtual void update();
	virtual int getType () { return OT_EXIT; }
	virtual void handleCollission(Object *o);
};

class Monster : public Object
{
public:
	enum MonsterType {FOLE, SKINNY, BUNNY};
	
private:
	static Anim *normal[MONSTER_NORMAL_NUM];
	MonsterType monsterType;
	int count;
	int dx;
	static SAMPLE *miau;
	static SAMPLE *ought;
public:
	Monster(MonsterType type);
	static void init(Resources *res);
	virtual void update();

	// ugly hack - when monster dies, solid is off
	virtual int getType () { return (solid ? OT_MONSTER : OT_NOT_SPECIFIED); }
	virtual void handleCollission(Object *o);
};

#endif
