#ifndef MAIN_H
#define MAIN_H

#include <allegro.h>
#include "resources.h"
#include "engine.h"
#include "menu.h"
#include "testview.h"
#include "settings.h"


class Main
{
	friend class Engine;
	friend class Menu;
private:
	BITMAP *buffer;
	Resources resources;
	Menu menu;
	Engine engine;
	ALSPC_PLAYER *alspc_player;
	Settings settings;
	
	int frame_count;
	int frame_counter;
	int last_fps;
	int update_counter;
	
	bool cheatOn;
	bool cheatUnlocked;
	const int update_speed;
	
	//state machine
	int state; 
	// start menu, resume menu, playing, quitting
	
	void draw ();
	void update ();
	
	void playMusic (const char *id);
	void playSample (SAMPLE *s);
	void playMusic (ALSPC_DATA *alspc_data);
	Resources* getResources () { return &resources; }
	int getCounter () { return counter; }
	
public:
	static volatile int counter;

	Main ();
	int init(int argc, const char *const *argv);
	void run();
	void done();
	~Main();
	
	bool isCheatOn() { return cheatOn; }
	void setCheatOn(bool value) { cheatOn = value; }
	bool isCheatUnlocked() { return cheatUnlocked; }
	void setCheatUnlocked(bool value) { cheatUnlocked = value; }
	
	Button* getButton() { return settings.button; }
	bool isSoundOn() { return settings.soundOn; }
	void setSoundOn(bool value); 
	bool isMusicOn() { return settings.music; }
	void setMusicOn(bool value);
	bool isStereoOn() { return settings.stereo; }
	void setStereoOn(bool value); 
	bool isHifiOn() { return settings.hifi; }
	void setHifiOn(bool value);
};

#endif
