#ifndef BUTTONS_H
#define BUTTONS_H

class Button
{
private:
	int scancode; // contains keyboard scancode
public:
	Button (int newcode = 0) { scancode = newcode; }
	bool getState();

	void setScancode (int newcode) { scancode = newcode; }
	int getScancode () { return scancode; }
	const char *name();
};

// install the keyboard lowlevel callback
void initKeyboard ();

// reset scancode to 0 so you can start monitoring for the next keypress
void resetLastScancode();

// return last pressed key. Should return 0 after resetLastScancode
int getLastScancode();

#endif
