#include <allegro.h>
#include <map>
#include <string>
#include <vector>
#include <alspc.h>
#include <tegel.h>
#include "testview.h"

#ifndef RESOURCES_H
#define RESOURCES_H

class Anim;
class Levelset;
class CutScene;
	
class Resources
{
	friend class Testview; // for debugging
	
	std::vector<DATAFILE*> data;
	std::vector<TEG_MAP*> maps; // seperately loaded maps

	std::map <std::string, Anim*> animlist;
	std::map <std::string, TEG_MAP*> maplist;	
	std::map <std::string, Levelset*> levelsets;
	std::map <std::string, CutScene*> cutscenes;
	
	std::vector <RLE_SPRITE*> generated; // run-time generated RLE's
	void makeHitAnim (char *id, char *id2);
public:
	int init(); // loads resources
	~Resources();
	
	Levelset *getLevelset (std::string id);
	Anim *getAnim (std::string id);
	FONT *getFont (std::string id);
	RLE_SPRITE *getRle (std::string id);
	SAMPLE *getSample (std::string id);  
	ALSPC_DATA *getSPC (std::string id);
	TEG_MAP *getMap (std::string id);
	TEG_TILELIST *getTilelist (std::string id);
	CutScene *getCutScene (std::string id);
};

#endif
