#ifndef LEVELSET_H
#define LEVELSET_H

#include <alspc.h>
#include <tegel.h>
#include <vector>
#include <string>
#include "resources.h"
#include "dom.h"

class LevelsetItem
{
	public:
	TEG_MAP *map;
	TEG_MAP *background;
	ALSPC_DATA *music;
};

class Levelset
{
	public:
	
	std::vector<LevelsetItem> levels;
	
	static int loadFromXml (
	xdom::DomNode *node, Resources *res, 
	std::map<std::string, Levelset*> &result);
};

#endif
