#include "settings.h"
#include <allegro.h>
#include <string.h>

Settings::Settings()
{
   // these settings are the default
	// they are overriden by the info in xelda.cfg
	// and then by command line parameters
	music = true;
	hifi = true;
	stereo = true;
	soundOn = true;
	fpsOn = false;
	windowed = false;
	doublesize = false;
	
	button[btnLeft].setScancode (KEY_LEFT);
	button[btnRight].setScancode (KEY_RIGHT);
	button[btnDown].setScancode (KEY_DOWN);
	button[btnJump].setScancode (KEY_SPACE);
	button[btnAction].setScancode (KEY_ALT);
	// end of config defaults
}


void Settings::getFromConfig()
{
	music = get_config_int ("xelda", "music", music);
	hifi = get_config_int ("xelda", "hifi", hifi);
	stereo = get_config_int ("xelda", "stereo", stereo);
	soundOn = get_config_int ("xelda", "sound", soundOn);
	fpsOn = get_config_int ("xelda", "fps", fpsOn);
	windowed = get_config_int ("xelda", "windowed", windowed);
	doublesize = get_config_int ("xelda", "doublesize", doublesize);

	button[btnLeft].setScancode (get_config_int ("xelda", "key_left", button[btnLeft].getScancode()));
	button[btnRight].setScancode (get_config_int ("xelda", "key_right", button[btnRight].getScancode()));
	button[btnDown].setScancode (get_config_int ("xelda", "key_down", button[btnDown].getScancode()));
	button[btnAction].setScancode (get_config_int ("xelda", "key_action", button[btnAction].getScancode()));
	button[btnJump].setScancode (get_config_int ("xelda", "key_jump", button[btnJump].getScancode()));
}	

void Settings::getFromArgs(int argc, const char *const *argv)
{
		// parse command line arguments
	int i;
	for (i = 1; i < argc; i++)
	{
		if (strcmp (argv[i], "-nosound") == 0)
		{
			soundOn = false;
		}
		else if (strcmp (argv[i], "-windowed") == 0)
		{
			windowed = true;
		}
		else if (strcmp (argv[i], "-doublesize") == 0)
		{
			doublesize = true;
		}
		else if (strcmp (argv[i], "-fullscreen") == 0)
		{
			windowed = false;
		}
		else if (strcmp (argv[i], "-normalsize") == 0)
		{
			doublesize = false;
		}
		else if (strcmp (argv[i], "-showfps") == 0)
		{
			fpsOn = true;
		}
		else
		{
			allegro_message (
				"warning: Couldn't parse a command line argument %i\n%s",		
				i, argv[i]);
		}			
	}   

}
