#include "player.h"
#include "resources.h"
#include "anim.h"
#include "engine.h"
#include "main.h"
#include "monster.h"

SAMPLE *Bullet::skullbreak;

Bullet::Bullet(fix _dx, fix _dy) : dx (_dx), dy (_dy)
{
	visible = true;
	hasGravity = false;
	timer = 10;
	solid = false;
}

void Bullet::init(Resources *res)
{
	skullbreak = res->getSample ("break");
}

void Bullet::update()
{
	try_move (dx, dy);
	timer--;

	if (timer <= 0) 
	{
		kill();
		return;
	}
		
	int mx1, my1, mx2, my2;
	int ix, iy;
	TEG_MAP *map = getMap();
	mx1 = ((int)getx()) / map->tilelist->tilew;
	my1 = ((int)gety()) / map->tilelist->tileh;
	mx2 = ((int)getx() + w - 1) / map->tilelist->tilew;
	my2 = ((int)gety() + h - 1) / map->tilelist->tileh;
			
	// loop through all map positions we touch with the solid region
	for (ix = mx1; ix <= mx2; ++ix)
	{
		for (iy = my1; iy <= my2; ++iy)
		{
			// see if there is a solid tile at this position
			if (getTileStackFlags (ix, iy) & TS_SOFT)
			{
				teg_mapput (map, 1, ix, iy, 0);
				kill();
			}
		}
	}
}
	
void Bullet::handleCollission(Object *o)
{
	if (o->getType() == OT_MONSTER) // monster
	{
		kill();
	}
}
	

Player::Player()
{
	visible = true;
	hittimer = 0;
	setAnim(stand[0]);
	hasGravity = true;
	jumptimer = 0;
	dir = 0;
	attacktimer = 0;
	state = STAND;
	button = NULL;
}

Anim *Player::stand[2];
Anim *Player::jumpup[2];
Anim *Player::jumpdown[2];
Anim *Player::duck[2];
Anim *Player::attackup[2];
Anim *Player::attackdown[2];
Anim *Player::walk[2];

SAMPLE *Player::shoot;
SAMPLE *Player::explode;
SAMPLE *Player::bonus;

void Player::init(Resources *res)
{
	stand[0] = res->getAnim ("stand");
	jumpup[0] = res->getAnim ("jump");
	jumpdown[0] = res->getAnim ("jump");
	duck[0] = res->getAnim ("ducking");
	attackup[0] = res->getAnim ("att1");
	attackdown[0] = res->getAnim ("att2");
	walk[0] = res->getAnim ("walk");
	stand[1] = res->getAnim ("standf");
	jumpup[1] = res->getAnim ("jumpf");
	jumpdown[1] = res->getAnim ("jumpf");
	duck[1] = res->getAnim ("duckingf");
	attackup[1] = res->getAnim ("att1f");
	attackdown[1] = res->getAnim ("att2f");
	walk[1] = res->getAnim ("walkf");

	shoot = res->getSample ("SHOOT");
	explode = res->getSample ("EXPL");
	bonus = res->getSample ("BLIP");
}

void Player::update()
{
	assert (parent);
		if (!button) button = parent->getParent()->getParent()->getButton();
		assert (button);
		
	HeroState oldState = state;
	
	if (hittimer > 0)
	{
		hittimer--;
		visible = !(hittimer & 1);
	}
		   
	if (button[btnJump].getState()) 
	{
		if (jumptimer == 0 && supportType & TS_SOLID && state != DUCK)
		{
			jumptimer = 16;
		}
		if (jumptimer > 0)
		{
			jump_dy = -5;
			jumptimer--;
		}
	}
	else
	{
		jumptimer = 0;
	}
	
	bool freshAnim = false;
	
	if (attacktimer > 0)
	{
		attacktimer --;
		if (attacktimer == 4)
		{
			freshAnim = true;
		}
	}
	else
	{
		if (button[btnAction].getState())
		{
			attacktimer = 8;
			parent->getParent()->playSample (shoot);

			if (state == DUCK)
			{
				setAnim (attackdown[dir]);
				// generate bullet...
				Bullet *bullet = new Bullet(fix(dir == 0 ? -1 : 1), fix(0));			
				parent->add (bullet);
				bullet->setLocation (getx() + (dir == 0 ? -8 : 16), gety() + 15);
			}
			else
			{
				setAnim (attackup[dir]);
				// generate bullet...
				Bullet *bullet = new Bullet(fix(dir == 0 ? -1 : 1), fix(0));			
				parent->add (bullet);
				bullet->setLocation (getx() + (dir == 0 ? -8 : 16), gety() + 5);
			}
			
		}
	}
	
	fix dx = fix(0), dy = fix(0);
	
	if (button[btnDown].getState())
	{
		state = DUCK;
		if (button[btnLeft].getState() && dir == 1)
		{
			dir = 0;
			freshAnim = true;
		} else if (button[btnRight].getState() && dir == 0)
		{
			dir = 1;
			freshAnim = true;
		}
	} 
	else 
	{
		if (button[btnLeft].getState() && getx() > 0)
		{
			dx = -2;
			if (dir != 0) freshAnim = true;
			dir = 0;
			state = WALK;
		} else if (button[btnRight].getState())
		{
			dx = 2;
			if (dir != 1) freshAnim = true;
			dir = 1;
			state = WALK;
		} else
		{
			state = STAND;
		}
	}
	
	if (freshAnim || oldState != state)
	{
		switch (state)
		{
			case WALK:
				setAnim (walk[dir]);
				break;
			case DUCK:
				setAnim (duck[dir]);
				break;
			case STAND:
				setAnim (stand[dir]);
				break;
			case JUMP:
				break;
			case FALL:
				break;
		}
	}
	
	try_move (dx, dy);
	if (gety() > 260)
	{
		Engine *e = parent->getParent();
		e->die(); // send die signal
		kill();
	}
	Object::update();
}

void Player::hit()
{
	hittimer = 50;
	Engine *e = parent->getParent();
	parent->getParent()->playSample (explode);
	if (!e->isCheatOn())
	{
		e->health -= 10;
		if (e->health <= 0)
		{
			e->die(); // send die signal
			kill();
		}
	}	
}

void Player::handleCollission (Object *o)
{
	if (o->getType() == OT_MONSTER) // monster
	{
		if (hittimer == 0) hit();
	}
	if (o->getType() == OT_EXIT) // exit
	{
		Engine *e = parent->getParent();		
		e->nextLevel(); // send exit signal
	}
}
