#include "monster.h"
#include "resources.h"
#include "engine.h"
#include "main.h"
#include <stdlib.h>
#include <assert.h>

Anim *ExitObject::normal[EXITOBJECT_NORMAL_NUM];
Anim *Monster::normal[MONSTER_NORMAL_NUM];

SAMPLE *Monster::miau;
SAMPLE *Monster::ought;
SAMPLE *ExitObject::blip;

ExitObject::ExitObject(ExitType type) : exitObjectType (type)
{
	visible = true;
	solid = true;
	hasGravity = true;
	isfound = false;
	switch (exitObjectType)
	{
		case HASH: setAnim(normal[0]); break;
		case TEDDY: setAnim(normal[1]); break;
		case DONUT: setAnim(normal[2]); break;
		case PRINCESS: setAnim(normal[3]); break;
	}
}

void ExitObject::init(Resources *res)
{
	normal[0] = res->getAnim ("hash");
	normal[1] = res->getAnim ("teddy");
	normal[2] = res->getAnim ("donut");
	normal[3] = res->getAnim ("princess");

	blip = res->getSample ("blip");

}

void ExitObject::update()
{
	if (isfound)
	{
		if (supportType & TS_SOLID)
		{
			jump_dy = -4;
		}
	}
	Object::update();
}

void ExitObject::handleCollission(Object *o)
{
	if (o->getType() == OT_PLAYER)
	{
		if (!isfound)
		{
			isfound = true;
			parent->getParent()->playSample (blip);
		}
	}
}

Monster::Monster(MonsterType type) : monsterType (type)
{
	visible = true;
	hasGravity = true;  
	switch (monsterType)
	{
		case SKINNY: setAnim(normal[0]); break;
		case FOLE: setAnim(normal[1]); break;
		case BUNNY: setAnim(normal[2]); break;
	}	
	count = 100;
	dx = 1;
}

void Monster::init(Resources *res)
{
	normal[0] = res->getAnim ("skinny");
	normal[1] = res->getAnim ("fole");
	normal[2] = res->getAnim ("bunny");

	miau = res->getSample ("miau");
	ought = res->getSample ("ought");

}

void Monster::update()
{
	count--;
	if (count == 0)
	{
		dx = -dx;
		count = rand() % 100 + 50;
	}
	
	int mx = getx() + (w / 2) + (3 * dx);
	int my = gety() + h + 1;
	TEG_MAP *map = getMap();
	int lookahead = getTileStackFlags (mx / map->tilelist->tilew, my / map->tilelist->tileh);
	if (!(lookahead & TS_SOLID))
	{
		dx = -dx;
		count = 100;
	}
		
	try_move (fix(dx), fix(0));
	Object::update();
}

void Monster::handleCollission(Object *o)
{
	if (o->getType() == OT_BULLET) // player attack
	{
		//~ kill();
		solid = false; // will fall through map
		if (monsterType == FOLE)
		{
			parent->getParent()->playSample (miau);
		}
		else if (monsterType == SKINNY)
		{
			parent->getParent()->playSample (ought);
		}
	}	
	if (o->getType() == OT_MONSTER) // player attack
	{
		if (rand() % 100 > 80) dx = -dx;
	}	
}


