#include "levelset.h"
#include <assert.h>

using namespace xdom;
using namespace std;

int Levelset::loadFromXml (DomNode *node, Resources *res, map<string, Levelset*> &result)
{
	pair<string, Levelset*> temp;
	assert (node->name == "levelset");
	temp.first = node->attributes["name"];   
	temp.second = new Levelset;
	
	for (vector<DomNode>::iterator i = node->children.begin();
		i != node->children.end(); ++i)
	{
		LevelsetItem x;
		x.map = res->getMap (i->attributes["map"]);
		x.background = res->getMap (i->attributes["bg"]);
		x.music = res->getSPC (i->attributes["music"]);
		temp.second->levels.push_back (x);
	}
	result.insert (temp);
	return 1;
}
