#include "anim.h"

using namespace xdom;
using namespace std;

void Anim::add (Frame &f)
{
	frames.push_back(f);
}

void Anim::loadFromXml (DomNode *n, Resources *res, map<string, Anim*> &result)
{
	assert (n->name == "anim");
	Anim *temp;
	Frame frame;
	int length = 0;
	string name = n->attributes["name"];
	vector<DomNode>::iterator i;
	temp = new Anim;
	for (i = n->children.begin(); i != n->children.end(); ++i)
	{
		assert (i->name == "frame");
		frame.time = atoi(i->attributes["time"].c_str());
		length += frame.time;
		frame.rle = res->getRle (i->attributes["rle"]);
		if (!frame.rle)
		{
			allegro_message ("error loading frame of animation %s", name.c_str());
		}
		frame.w = atoi(i->attributes["w"].c_str());
		frame.h = atoi(i->attributes["h"].c_str());
		frame.hotx = atoi(i->attributes["hotx"].c_str());
		frame.hoty = atoi(i->attributes["hoty"].c_str());
		temp->frames.push_back(frame);
	}
	temp->totalLength = length;
	result.insert (pair<string, Anim*>(name, temp));
}
