#ifndef PLAYER_H
#define PLAYER_H

#include "object.h"
#include "settings.h"

class Resources;

class Bullet : public Object
{
	fix dx, dy;
	int timer;
	static SAMPLE *skullbreak;
	
	public:
	
	Bullet(fix _dx, fix _dy);
	virtual void update();
	virtual int getType () { return OT_BULLET; }
	virtual void handleCollission(Object *o);
	static void init(Resources *res);
	
};

class Player : public Object
{
	enum HeroState { DUCK, WALK, STAND, JUMP, FALL };
	
	static Anim *stand[2];
	static Anim *jumpup[2];
	static Anim *jumpdown[2];
	static Anim *duck[2];
	static Anim *attackup[2];
	static Anim *attackdown[2];
	static Anim *walk[2];
	   
	HeroState state;
	
	int dir;
	int hittimer;
	int attacktimer;
	int jumptimer;
	static SAMPLE *shoot;
	static SAMPLE *explode;
	static SAMPLE *bonus;
	Button *button;

	void hit();
public:
	Player();
	virtual void update();
	static void init(Resources *res);
	virtual int getType () { return OT_PLAYER; }
	virtual void handleCollission(Object *o);
};

#endif
