#ifndef ENGINE_H
#define ENGINE_H

#include <allegro.h>
#include "object.h"
#include <tegel.h>
#include "levelset.h"

using namespace std;

class Main;
class Player;

class Engine
{
private:	
	Testview testview;

	int state;
	int oldState;

	int introTimer;
	int outroTimer;
	
	Levelset *levelset;
	CutScene *cutscene;
	unsigned int currentLevel; // index of current Level

	Main *parent;
	   
	Objects objects;
	Player *player;
	bool debug;
	
	TEG_MAP *level;
	TEG_MAP *background;
	int camera_x;

	void updateCamera();
public:
	Engine (Main *p);
	Main *getParent() { return parent; }
	void initGame ();
	void init(); // call once during startup
	void resume ();
	void draw (BITMAP *buffer);
	void update ();
	int getState () { return state; }
	
	void nextLevel(); // called when player reaches exit
	void initLevel (); // for beginning a new level
	
	Player *getPlayer () { return player; }
	TEG_MAP *getMap () { return level; }
	void doneLevel (); // clean up objects etc.
	bool isDebug () { return debug; }
	bool isCheatOn ();
	int getCurrentLevel () { return currentLevel; }

	int getCounter ();
	Resources* getResources ();
	void playMusic (const char *id);
	void playSample (SAMPLE *s);
	void playMusic (ALSPC_DATA *alspc_data);
	
	// player stats		
	int lives;
	int health;
	
	void die(); // called when player dies
	
};

#endif
