#ifndef ANIM_H
#define ANIM_H

#include "resources.h"
#include <stdio.h>
#include <vector>
#include <map>
#include <string>
#include <assert.h>
#include "dom.h"

class Frame
{
public:
	RLE_SPRITE *rle;
	int time;
	int w;
	int h;
	int hotx;
	int hoty;
};

class Anim
{
private:
	std::vector<Frame> frames;
	int totalLength;
public:
	void add (Frame &f);
	int getTotalLength() { return totalLength; }
	RLE_SPRITE *getFrameRle (int f) 
	{
		assert (f >= 0 && f < getFrameCount());
		return frames[f].rle;
	}
	Frame *getFrame (int f)
	{
		assert (f >= 0 && f < getFrameCount());
	return &(frames[f]);
	}
	int getFrameTime (int f)
	{
		assert (f >= 0 && f < getFrameCount());
		return frames[f].time;
	}
	int getFrameCount()
	{
		return frames.size();
	}
	
	static void loadFromXml (xdom::DomNode *n, Resources *res, std::map<std::string, Anim*> &result);
};

#endif
