/*
		Operation Black Sun 2 Script Header File
		All Scripted GameObjects Need To Include This
                DO NOT MODIFY!!

		File:	obsobj.sh
		Author:	Jrg Rppel
*/

#ifndef OBSOBJECT_INCLUDED

#include stdlib

// the different logtypes
#define	LOG_INFO		0	// always written to logfile and console
#define LOG_INFO_DBG	1	// only written if debugmode is on
#define	LOG_ERROR		2	// always written
#define	LOG_WARNING		3	// always written

// call this to write to blacksun's logfile - printf syntax
import void log(int logtype, char *str, ...);

// standard funtions
import int sprintf(char *,...);
import int rand(int a);

// only w & h components of BITMAP are interesting for script
// the actual BITMAP information is not available to script
struct BITMAP
{
	import int get_w();
	import int get_h();
};

// array of BITMAPs with array size
struct GFX
{
	BITMAP	**bmp;
	int		count;
};
	
// a sound sample
typedef void SFX;

// request resources
import SFX *request_sfx(char *name);
import GFX *request_gfx(char *name);

// used to generate class identifiers
#define CLASS_ID(a,b,c,d)     (((a)<<24) | ((b)<<16) | ((c)<<8) | (d))

// possible object flags
#define OF_EDITOR			1		// object is visible in editor
#define	OF_SHOOTABLE		2		// object can be hit by projectiles
#define OF_SOLID			4		// other objects can bump into it

// the class which holds all registration data for current script
struct OBJ_CLASS
{
public:
	import void store_my_data(void *data, int size);
	import void restore_my_data(void *data);
	import void set_pic(void *pic);
	import void set_size(int w, int h);
	import void set_draw_distance(int d);
	import void set_flags(int flags);
	import void set_class_id(int id);
	import void registration_failed();
};

// gameobject class
struct GAME_OBJECT
{
public:
	import void draw_bmp(BITMAP *bmp, int dx, int dy);
	import int get_x();
	import int get_y();
	import int get_center_x();
	import int get_center_y();
	import int get_w();
	import int get_h();
	import int get_map();
	import int get_angle();
	import float get_scale();
	import void set_position(int x, int y, int map);
	import void set_angle(int angle);
	import void set_scale(float scale);
	import void set_x(int x);
	import void set_y(int y);
};

#define OBSOBJECT_INCLUDED
#endif