#ifndef LASER_ROBOTS_H
#define LASER_ROBOTS_H

#include <allegro.h>
#include "LaserBall.h"

/* possible particle commands (ie. language keywords) */
#define LB_COMMAND_INIT   1
#define LB_COMMAND_SET    2
#define LB_COMMAND_IF     3
#define LB_COMMAND_WHILE  4
#define LB_COMMAND_SRAND  5
#define LB_COMMAND_GO     6
#define LB_COMMAND_BACK   7
#define LB_COMMAND_LEFT   8
#define LB_COMMAND_RIGHT  9
#define LB_COMMAND_FIRE   10


/* each laser robot is controlled by a command list */
class LB_COMMAND {
public:
	int type;                       /* command type */
	int line;                       /* source line number */
	char *var;                      /* variable to be set */
	char *exp;                      /* arithmetic expression */
	LB_COMMAND *cmd;                /* nested, child command list (if) */
	LB_COMMAND *cmd2;               /* more child commands (else) */
	LB_COMMAND *next;               /* linked list pointer */
};


/* robot store their state variables in these structures */
class LB_VARIABLE {
public:
	char *name;                      /* variable name */
	double val;                      /* current value */
	LB_VARIABLE *next;               /* linked list pointer */
};


/* a specific robot instance */ 
class LB_ROBOT {
public:
	int num;                         /* unique ID number */
  char *name;                      /* robot name */
  LB_COMMAND *cmd;                 /* command list */
	LB_VARIABLE *var;                /* list of variables */
	LB_ROBOT *next;                  /* linked list pointer */
};

LB_ROBOT *load_lb(char *filename, char *error);
int process_lb_cmd(LASER_BALL *ball, LB_ROBOT *lb, LB_COMMAND *cmd, int init, int set, char *error);

#endif