#ifndef LASER_BALL_H
#define LASER_BALL_H

#include <math.h>
#include <allegro.h>

/* global variables defines */
#define MAX_BALLS    4
#define MAX_PLAYERS  50
#define LASER_PI     3.1415
#define MAX_SPEED    5
#define MAX_LASER    300
#define MAX_LIFE     1000 
#define MAX_ENERGY   1000 
#define VAR_SPEED    0.2
#define VAR_ANGLE    2
#define VAR_LASER    20
#define VAR_LIFE     3
#define VAR_ENERGY   2

/* commands defines */
#define COMMAND_NONE           0
#define COMMAND_GO_STRAIGHT    1
#define COMMAND_GO_BACK        2
#define COMMAND_ROTATE_LEFT    3
#define COMMAND_ROTATE_RIGHT   4
#define COMMAND_FIRE           5

/* keys config defines */
#define KEY_GO_UP          0
#define KEY_GO_DOWN        1
#define KEY_ROTATE_LEFT    2
#define KEY_ROTATE_RIGHT   3
#define KEY_FIRE           4

/* external global variables */
extern int x_min, x_max, y_min, y_max;

/* simple 2D vector class */
class VECTOR {
public:
	float x, y;
	VECTOR() : x(0), y(0) {};
	VECTOR(float x, float y) : x(x), y(y) {};
	inline float magnitude() { return sqrt(x * x + y * y); };
	inline float angle() { return (x != 0 || y != 0)? atan2(y, x) : 0; };
	inline void normalize() { x = cos(angle()); y = sin(angle()); };
	inline float dot(VECTOR v) { return x * v.x + y * v.y;};
	inline VECTOR plus(VECTOR v) { return VECTOR(x + v.x, y + v.y);};
	inline VECTOR minus(VECTOR v) { return VECTOR(x - v.x, y - v.y);};
	inline VECTOR times(float d) {return VECTOR(x * d, y * d);};
	inline VECTOR divide(float d) {return VECTOR(x / d, y / d);};
	inline VECTOR copy() { return VECTOR(x, y); }
};

/* laser ball object class */
class LASER_BALL {
public:

	/* members */
	double x, y;    // position
	double radius;  // radius
	int angle;      // angular position
	VECTOR v;       // velocity
	VECTOR a;       // acceleration
	int laser;      // laser length
	int life;       // life
	int energy;     // laser energy
	bool reloading; // laser reloading flag
	int hits;       // laser hits received
	bool human;     // player type flag
	bool active;    // active player flag
	int key[5];     // key controls
	int command_go, command_rotate, command_fire; // commands flags

	/* methods */
	LASER_BALL();
	void position(int x, int y);
	void random_position();
	void rotate_left();
	void rotate_right();
	void go_straight();
	void go_back();
	void fire();
	fixed fix_angle();
	float rad_angle();
	void adjust_angle();
	void apply_commands();
	void update();
	bool is_human();
	bool is_active();
	void set_keys(int up, int down, int left, int right, int fire);
	float distance(LASER_BALL &b);
	bool check_collision(LASER_BALL& b);
	void collide(LASER_BALL& b);
	bool check_laser(LASER_BALL& b);
	void add_hit();
	void restart();
};

#endif
