#include <stdio.h>
#include <stdlib.h>
#include "allegro.h"
#include <string.h>

int top(int num){
  if (num<0) return(0); else
  if (num>255) return(255); else return(num);
}

main(int argc, char *argv[]) {
  int redu,i,j,x,y,blancos,trojo,tverde,tazul,prov,*lista_sig,*lista_act,*pprov;
  BITMAP *partida,*final,*ultim;
  PALLETE pal;

  if (argc<4) {
    printf ("Debes introducir tres o cuatro parmetros: nombres de ");
    printf ("las imagenes, factor de reduccin y parmetro\n");
    printf ("Trata slo imgenes en 24 bits de color y el color transparente");
    printf (" es el negro.\n");
    printf ("El parmetro puede ser:\nd (defecto) 8 bits de resultado\n");
    printf ("a 24 bits y tga\nf 24 bits y pcx\n");
    exit (1);
  }
  redu=atoi(argv[3]);
  if (redu<=0) {
    printf ("Factor de reduccin incorrecto.");
    exit (2);
  } else printf(" factor de reduccion: %i\n",redu);
  allegro_init();
  install_keyboard();
  set_color_depth(24);
  //set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
  partida=load_tga(argv[1],pal);
  if(partida==NULL){
    allegro_exit();
    printf("Problemas dimensionando bitmaps.");
    exit (4);
  }
  //blit(partida,screen,0,0,0,0,partida->w,partida->h);
  if (((partida->w)%redu!=0)||(((partida->h)%redu!=0))){
    allegro_exit();
    printf("El factor de reduccin no es apropiado para la imagen.");
    exit (3);
  }
  final=create_bitmap((partida->w)/redu,(partida->h)/redu);
  if(final==NULL){
    allegro_exit();
    printf("Problemas dimensionando bitmaps.");
    exit (4);
  }
  for(x=0;x<final->w;++x)
    for(y=0;y<final->h;++y){
      blancos=0;
      trojo=0;
      tazul=0;
      tverde=0;
      for(i=0;i<redu;++i)
        for(j=0;j<redu;++j){
          prov=getpixel(partida,x*redu+i,y*redu+j);
          if (prov==makecol(0,0,0)) ++blancos;
          else {
             trojo+=getr(prov);
             tverde+=getg(prov);
             tazul+=getb(prov);
          }
      }
      if (2*blancos>redu*redu) putpixel(final,x,y,makecol(255,0,255));
      else{
        prov=redu*redu-blancos;
        putpixel(final,x,y,makecol(trojo/prov,tverde/prov,tazul/prov));
      }
      //putpixel(screen,x,y,getpixel(final,x,y));
  }
  destroy_bitmap(partida);
  printf("argc: %i\n",argc);
  printf("argv[4]: %s\n",argv[4]);
  printf("ancho de la imagen obtenida: %i\n",final->w);
  if ((argc==5)&&(stricmp(argv[4],"f")==0)){
      save_pcx(argv[2],final,pal);
      printf("He salvado pcx a 24 bits");
      exit(0);
  }
  printf("argc: %i\n",argc);
  printf("argv[4]: %s\n",argv[4]);
  if((argc==5)&&(stricmp(argv[4],"a")==0)){
      save_tga(argv[2],final,pal);
      printf("He salvado tga a 24 bits");
      exit(0);
  }
  //readkey();
  //Carga la imagen con la paleta apropiada para el juego
  partida=load_tga("filtro.tga",pal);
  select_palette(pal);

  /* Para mostrar la paleta
  for (i=0;i<16;++i) for(j=0;j<16;++j){
    rectfill(screen,i*10,j*10,i*10+10,j*10+10,palette_color[i+j*16]);
  }*/
  lista_act=malloc(3*final->w*sizeof(int));
  lista_sig=malloc(3*final->w*sizeof(int));
  for (i=0;i<final->w;++i)for (j=0;j<3;++j){
    lista_sig[3*i+j]=0;
    lista_act[3*i+j]=0;
  }
  ultim=create_bitmap_ex(8,final->w,final->h);
  for (j=0;j<final->h;++j){
    pprov=lista_act;lista_act=lista_sig;lista_sig=pprov;
    for (i=0;i<final->w;++i){
      lista_sig[3*i]=0;
      lista_sig[3*i+1]=0;
      lista_sig[3*i+2]=0;
    }
    for(i=0;i<final->w;++i){
      prov=getpixel(final,i,j);
      if ((getr(prov)==0)&&(getb(prov)==0)&&(getg(prov)==0)) prov=0;
      else{
        lista_act[3*i]+=getr(prov)<<3;
        lista_act[3*i+1]+=getg(prov)<<3;
        lista_act[3*i+2]+=getb(prov)<<3;
        prov=makecol8(top(lista_act[3*i]>>3),top(lista_act[3*i+1]>>3),
          top(lista_act[3*i+2]>>3));
      }
      putpixel(ultim,i,j,prov);
      putpixel(screen,i,j,palette_color[prov]);
      lista_act[3*i]-=getr(palette_color[prov])<<3;
      lista_act[3*i+1]-=getg(palette_color[prov])<<3;
      //Que lo ponga en pantalla
      //printf("Verde: %i ",lista_act[3*i+1]);
      lista_act[3*i+2]-=getb(palette_color[prov])<<3;
      if(i>0){
        lista_sig[3*i-3]+=lista_act[3*i]>>3;
        lista_sig[3*i-2]+=lista_act[3*i+1]>>3;
        lista_sig[3*i-1]+=lista_act[3*i+2]>>3;
      }
      if(i+1<final->w){
        lista_sig[3*i+3]+=lista_act[3*i]>>3;
        lista_sig[3*i+4]+=lista_act[3*i+1]>>3;
        lista_sig[3*i+5]+=lista_act[3*i+2]>>3;
        lista_act[3*i+3]+=(3*lista_act[3*i])>>3;
        lista_act[3*i+4]+=(3*lista_act[3*i+1])>>3;
        lista_act[3*i+5]+=(3*lista_act[3*i+2])>>3;
      }
      lista_sig[3*i]+=(3*lista_act[3*i])>>3;
      lista_sig[3*i+1]+=(3*lista_act[3*i+1])>>3;
      lista_sig[3*i+2]+=(3*lista_act[3*i+2])>>3;
    }
  }

  //readkey();
  save_tga(argv[2],ultim,pal);
  allegro_exit();
  exit(0);
}
END_OF_MAIN();
