#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "allegro.h"
#include "cola.h"
#include "rutini.h"

typedef struct RECT{
  int x,y,w,h;
}RECT;

#define MAXSUCIOS  150

RECT sucios[MAXSUCIOS];
extern int numsucios,modo,tama,numima;
extern BITMAP *pantalla,*imagen,*estatico,*dib_fondo,**piezas;
extern PALETTE pal;
extern volatile int escenas,ips_cuent,ips;

int rect_cmp(const void *p,const void *q){
  RECT *r= (RECT *)p;
  RECT *s= (RECT *)q;

  return (r->y-s->y);
}

void sube_escenas(){
  escenas++;
}
END_OF_FUNCTION(sube_escenas);

void cuenta_ips(){
  ips=ips_cuent;
  ips_cuent=0;
}
END_OF_FUNCTION(cuenta_ips);

int start(int num){
  int vuelta;
  allegro_init();
  install_keyboard();
  install_timer();

  set_color_depth(8);
  //readkey();
  switch (num){
    case 0:
      vuelta=set_gfx_mode(GFX_MODEX,320,240,0,0);
      tama=16;
      //imagen=load_tga("qa162.tga", pal);
      break;
    case 1:
      vuelta=set_gfx_mode(GFX_AUTODETECT,320,240,0,0);
      tama=16;
      //imagen=load_tga("qa162.tga", pal);
      break;
    case 2:
      vuelta=set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
      tama=32;
      //imagen=load_tga("qa322.tga", pal);
      break;
    case 3:
      vuelta=set_gfx_mode(GFX_AUTODETECT,800,600,0,0);
      tama=40;
      //imagen=load_tga("qa402.tga", pal);
      break;
    case 4:
      vuelta=set_gfx_mode(GFX_AUTODETECT,1024,768,0,0);
      tama=50;
      //imagen=load_tga("qa502.tga", pal);
      break;
    default:return(1);
  }
  dib_fondo=load_tga("fondo.tga", pal);
  pantalla=create_bitmap(SCREEN_W,SCREEN_H);
  if ((dib_fondo==NULL)||(pantalla==NULL)) {
    exit(2);
  }
  set_pallete(pal);
  //rectfill(screen,0,0,200,300,3);
  //blit(imagen,screen,0,0,320,200,imagen->w,imagen->h);
  //blit(imagen,screen,0,0,0,0,imagen->w,imagen->h);
  //textout_centre(screen,font,"Pulse Escape",SCREEN_W/2,SCREEN_H/2,255);
  //readkey();
  //x=320;y=200;
  LOCK_VARIABLE(escenas);
  LOCK_FUNCTION(sube_escenas);
  install_int_ex(sube_escenas, BPS_TO_TIMER(50));
  LOCK_VARIABLE(ips_cuent);
  LOCK_VARIABLE(ips);
  LOCK_FUNCTION(cuenta_ips);
  //install_int_ex(cuenta_ips, BPS_TO_TIMER(1));
  estatico=create_bitmap(SCREEN_W,SCREEN_H);
  inicia_cola();
  inicia_bcola();
  //exit (1);
  return(vuelta);
}

void descarga(void){
  COLADOR *puntero;
  int i;

  numsucios=0;
  for(puntero=inicia_bucle_bcola();puntero!=NULL;puntero=siguiente_bcola()){
    blit(puntero->origen,puntero->destino,puntero->x1,puntero->y1,puntero->x2,
      puntero->y2,puntero->h,puntero->v);
    if (numsucios<MAXSUCIOS){
      sucios[numsucios].x=puntero->x2;
      sucios[numsucios].y=puntero->y2;
      sucios[numsucios].w=puntero->h;
      sucios[numsucios].h=puntero->v;
      ++numsucios;
    }
  }
  vacia_bcola();
  for(puntero=inicia_bucle_cola();puntero!=NULL;puntero=siguiente_cola()){
    masked_blit(puntero->origen,puntero->destino,puntero->x1,puntero->y1,puntero->x2,
      puntero->y2,puntero->h,puntero->v);
    if (numsucios<MAXSUCIOS){
      sucios[numsucios].x=puntero->x2;
      sucios[numsucios].y=puntero->y2;
      sucios[numsucios].w=puntero->h;
      sucios[numsucios].h=puntero->v;
      ++numsucios;
    }
  }
  vacia_cola();
  if (numsucios<MAXSUCIOS) {
    if(!gfx_driver->linear)
      qsort(sucios,numsucios,sizeof(RECT),rect_cmp);
    for(i=0;i<numsucios;++i)
      blit(pantalla,screen,sucios[i].x,sucios[i].y,sucios[i].x,sucios[i].y,
        sucios[i].w,sucios[i].h);
  } else
  blit(pantalla,screen,0,0,0,0,SCREEN_W,SCREEN_H);
}

void prepara_nivel(void){
  int i;
  char buf[42],prov[17];

  piezas=(BITMAP **)malloc(36*sizeof(BITMAP *));
  if(piezas==NULL) {
    exit(4);
  }
  for (i=0;i<36;++i){
    buf[0]=0;
    strcpy(buf,"qa");
    itoa(tama,prov,10);
    strcat(buf,prov);
    if (i<9) strcat(buf,"0");
    itoa(i+1,prov,10);
    strcat(buf,prov);
    strcat(buf,".tga");
    piezas[i]=load_tga(buf,pal);
    if(piezas[i]==NULL){
      exit(5);
    }
  }
}

BITMAP *tripleta(int *mat){
  int i;
  BITMAP *prov;

  prov=create_bitmap(tama,3*tama);
  for(i=0;i<3;++i)blit(piezas[mat[i]],prov,0,0,0,i*tama,tama,tama);
  return(prov);
}


