#include <stdlib.h>
#include <allegro.h>
#include "eje.h"
#include "qadat.h"


//Probablemente, variables externas en el futuro
extern int tama,ancini,altini,cols,altpant,colortrans;
extern int puntos,maxtiempo,puntoinicio,maxvar,altcol,numpiezas;
extern BITMAP *otrofondo;

extern int indica[11];
extern DATAFILE *datos;

BITMAP *marcador,*marcatiemp,*marcapunt,*marcapieza,*marcat1,*marcat2;
BITMAP *tetapas[8], *numeros[10], *Gestrella;


static int punt_ant,punt_nuevo,cont_marcador,t_representado,fpunt_ant,
  fpunt_nuevo,cont_marcapunt,pieza_ant,pieza_nuevo,cont_marcapieza,xmarcat,
  ymarcat;
struct Testrella {
  int x,y,vx,vy;
  struct Testrella *siguiente;
} *Lestrella;
struct Tpuntos {
  int x,y;
  BITMAP* valor;
  struct Tpuntos *siguiente;
} *Lpuntos;

void nuevo_puntos(int x,int y,int p){
  struct Tpuntos *temp;
  BITMAP *puntuacion;

  temp=(struct Tpuntos *)malloc(sizeof(struct Tpuntos));
  if(temp!=NULL){     //
    puntuacion=create_bitmap(24,8);
    if(puntuacion==NULL)free(temp);
    else{
      clear_to_color(puntuacion,colortrans);
      textprintf_centre(puntuacion,font,12,0,makecol(255,255,255),"%i",p);
      temp->valor=puntuacion;
      temp->x=x+tama/2-12;
      temp->y=y+tama/2-4;
      temp->siguiente=Lpuntos;
      Lpuntos=temp;
    }
  }
}

void prepara_puntos(void){ //Aqui preparamos la cola de los puntos
  Lpuntos=NULL;
}

void calcula_puntos(){
  struct Tpuntos *ant,*temp;
  for(;;){
    Lpuntos->y-=tama/16;
    if(Lpuntos->y<-tama){
      temp=Lpuntos->siguiente;
      destroy_bitmap(Lpuntos->valor);
      free(Lpuntos);
      Lpuntos=temp;
      if(temp==NULL){
        return;
      }
    }else break;
  }
  for(ant=Lpuntos,temp=ant->siguiente;temp!=NULL;
    ant=temp,temp=temp->siguiente){
    temp->y-=tama/16;
    if(temp->y<-tama){
      ant->siguiente=temp->siguiente;
      destroy_bitmap(temp->valor);
      free(temp);
      temp=ant;
      if(temp==NULL){
        break;
      }else continue;
    }
  }
}

void destruye_puntos(void){
  struct Tpuntos *temp;
  while(Lpuntos!=NULL){
    temp=Lpuntos->siguiente;
    destroy_bitmap(Lpuntos->valor);
    free(Lpuntos);
    Lpuntos=temp;
  }
}

void nueva_estrella(int x,int y){
  struct Testrella *temp;

  temp=(struct Testrella *)malloc(sizeof(struct Testrella));
  if(temp!=NULL){     //
    temp->x=x*200+(rand()%(tama+1))*100;
    temp->y=y*200+(rand()%(tama+1))*100;
    temp->vx=300-rand()%601;
    temp->vy=300-rand()%601;
    temp->siguiente=Lestrella;
    Lestrella=temp;
  }
}


void prepara_estrellas(void){ //Aqui preparamos el grafico de la estrella
  Lestrella=NULL;
  Gestrella=create_bitmap(tama/4,tama/4);
  clear_to_color(Gestrella,colortrans);
  circlefill(Gestrella,tama/8,tama/8,tama/8,makecol(255,255,255));
}

void calcula_estrellas(){
  struct Testrella *ant,*temp;
  for(;;){
    Lestrella->x+=Lestrella->vx;
    Lestrella->y+=Lestrella->vy;
    Lestrella->vy+=8;
    if(Lestrella->y>(altpant)*200){
      temp=Lestrella->siguiente;
      free(Lestrella);
      Lestrella=temp;
      if(temp==NULL){
        return;
      }
    }else break;
  }
  for(ant=Lestrella,temp=ant->siguiente;temp!=NULL;
    ant=temp,temp=temp->siguiente){
    temp->y+=temp->vy;
    if(temp->y>(altpant)*200){
      ant->siguiente=temp->siguiente;
      free(temp);
      temp=ant;
      if(temp==NULL){
        break;
      }else continue;
    }
    temp->x+=temp->vx;
    temp->vy+=8;
  }
}

void destruye_estrellas(void){
  struct Testrella *temp;
  destroy_bitmap(Gestrella);
  while(Lestrella!=NULL){
    temp=Lestrella->siguiente;
    free(Lestrella);
    Lestrella=temp;
  }
}

void prepara_marcaltura(void){
   marcat1=create_bitmap(tama/2,tama/4);
   clear_to_color(marcat1,makecol(255,255,128));
   marcat2=create_bitmap(tama,tama/4);
   clear_to_color(marcat2,makecol(255,32,32));
   xmarcat=0;
   ymarcat=altpant-altini-altcol*tama;
   draw_sprite(intermedio,marcat2,ancini+13*tama,
     altpant-altini-maxvar*tama+tama*3/8);
   draw_sprite_v_flip(intermedio,marcat2,0,
     altpant-altini-maxvar*tama+tama*3/8);
   draw_sprite(fondo,marcat2,ancini+13*tama,
     altpant-altini-maxvar*tama+tama*3/8);
   draw_sprite_v_flip(fondo,marcat2,0,
     altpant-altini-maxvar*tama+tama*3/8);
   draw_sprite(otrofondo,marcat2,ancini+13*tama,
     altpant-altini-maxvar*tama+tama*3/8);
   draw_sprite_v_flip(otrofondo,marcat2,0,
     altpant-altini-maxvar*tama+tama*3/8);
}

void calcula_marcaltura(void){
  int y_temp;
  y_temp=altpant-altini-altcol*tama;
  if(y_temp!=ymarcat){
    if(y_temp>ymarcat)ymarcat+=tama/8;
      else ymarcat-=tama/8;
  }
  xmarcat++;
  if(xmarcat>=32)xmarcat=-31;
}

void pinta_marcaltura(void){
  int i;
  for(i=0;i<13;i++){
   draw_sprite(intermedio,marcat1,ancini+i*tama+abs(xmarcat)*tama/64,
     ymarcat+tama*3/8);
  }
}

void borra_marcaltura(void){
  int i;
  for(i=0;i<13;i++){
   borra(ancini+i*tama+abs(xmarcat)*tama/64,
     ymarcat+tama*3/8,tama/2,tama/4);
  }
}

void destruye_marcaltura(void){
  destroy_bitmap(marcat1);
  destroy_bitmap(marcat2);
}

void prepara_marcatiemp(void){
  //int i;

/*  for(i=0;i<8;i++){
    tetapas[i]=create_bitmap(3*tama,tama);
    clear_to_color(tetapas[i],makecol(255-(255*i)/8,0,0));
  }*/
  marcatiemp=create_bitmap(3*tama,tama);
  //blit(tetapas[0],marcatiemp,0,0,0,0,3*tama,tama);
  draw_sprite(marcatiemp,(BITMAP *)datos[TI321_TGA].dat,0,0);
  t_representado=(50*maxtiempo)/30;
  draw_sprite(intermedio,marcatiemp,ancini+tama*15,tama*13);
  draw_sprite(fondo,marcatiemp,ancini+tama*15,tama*13);
}

void calcula_marcatiemp(void){
  //Esta se llama cuando tiempo>Tiempo representado
  int et,i;

  et=(tiempo*30)/(50*maxtiempo);
  //blit(tetapas[7],marcatiemp,0,0,0,0,(3*tama),tama);
  blit((BITMAP *)datos[TI321_TGA+7].dat,marcatiemp,0,0,0,0,(3*tama),tama);
  for(i=6;i>=0;i--){
    //blit(tetapas[i],marcatiemp,0,0,0,0,((24+i-et)*tama)/8,tama);
    blit((BITMAP *)datos[TI321_TGA+i].dat,marcatiemp,0,0,0,0,
      ((24+i-et)*tama)/8,tama);
  }
  blit(marcatiemp,intermedio,0,0,ancini+tama*15,tama*13,marcador->w,
    marcador->h);
  blit(marcatiemp,fondo,0,0,ancini+tama*15,tama*13,marcador->w,marcador->h);
  t_representado=((et-1)*50*maxtiempo)/30;
}

void destruye_marcatiemp(void){
  //int i;

  /*for(i=0;i<8;i++){
    destroy_bitmap(tetapas[i]);
  }*/
  destroy_bitmap(marcatiemp);
}

void prepara_marcapunt(void){
  int i,prov;

  marcapunt=create_bitmap(3*tama,tama);
  clear_to_color(marcapunt,makecol(20,20,20));
  prov=maxvar;
  for(i=1;i<=8;i++){
    draw_sprite(marcapunt,numeros[prov%10+1],(6-i)*tama/2,0);
    prov/=10;
    if(prov==0)break;
  }
  cont_marcapunt=0;
  fpunt_ant=maxvar;
  fpunt_nuevo=maxvar;
  blit(marcapunt,intermedio,0,0,ancini+tama*15,tama*11,marcapunt->w,
     marcapunt->h);
  blit(marcapunt,fondo,0,0,ancini+tama*15,tama*11,marcapunt->w,marcapunt->h);
}

void calcula_marcapunt(void){
  int i,prov,prov2,base;
  if(cont_marcapunt==0){
    if(maxvar+puntoinicio-puntos!=fpunt_nuevo){
      prov=maxvar+puntoinicio-puntos;
      if(prov<0)prov=0;
      prov2=fpunt_nuevo;
      base=1;
      for(i=1;i<=8;i++){
        if((prov%10)!=(prov2%10)){
            fpunt_nuevo-=base;
            if(prov2%10==0)fpunt_nuevo+=base*10;
        }
        prov/=10;
        prov2/=10;
        base*=10;
        if(prov==prov2)break;
      }
      cont_marcapunt=1;
    }
  }else{
    prov=fpunt_ant;
    prov2=fpunt_nuevo;
    for(i=1;i<=8;i++){
      if((prov%10)!=(prov2%10)){
        draw_sprite(marcapunt,numeros[prov%10+1],(6-i)*tama/2,
          (cont_marcapunt)*tama/8);
        draw_sprite(marcapunt,numeros[prov2%10+1],(6-i)*tama/2,
          (cont_marcapunt-8)*tama/8);
      }
      prov/=10;
      prov2/=10;
      if(prov==prov2)break;
    }
    cont_marcapunt++;
 }
  if(cont_marcapunt>8){
    fpunt_ant=fpunt_nuevo;
    cont_marcapunt=0;
    blit(marcapunt,intermedio,0,0,ancini+tama*15,tama*11,marcapunt->w,
      marcapunt->h);
    blit(marcapunt,fondo,0,0,ancini+tama*15,tama*11,marcapunt->w,marcapunt->h);
   }
}

void destruye_marcapunt(void){
  destroy_bitmap(marcapunt);
}

void prepara_marcapieza(void){
  marcapieza=create_bitmap(3*tama/2,tama);
  clear_to_color(marcapieza,makecol(20,20,20));
  cont_marcapieza=0;
  pieza_ant=0;
  pieza_nuevo=0;
  blit(marcapieza,intermedio,0,0,ancini+tama*33/2,tama*11,marcapieza->w,
    marcapieza->h);
  blit(marcapieza,fondo,0,0,ancini+tama*33/2,tama*11,marcapieza->w,
    marcapieza->h);
}

void calcula_marcapieza(void){
  int i,prov,prov2;
  if(cont_marcapieza==0){
    if(numpiezas!=pieza_nuevo){
      if(numpiezas<pieza_nuevo)pieza_nuevo--;
        else pieza_nuevo++;
      cont_marcapieza=1;
    }
  }else{
   /*textprintf(intermedio,font,100,32,1,"%i,%i:%i",pieza_ant,pieza_nuevo,cont_marcapieza);
   refresca();
   borra(100,32,300,30);
   while (keypressed())readkey();
   while (!keypressed());
   while (keypressed())readkey();*/
    prov=pieza_ant;
    prov2=pieza_nuevo;
    if(pieza_nuevo<pieza_ant)for(i=1;i<=3;i++){
      if((prov%10)!=(prov2%10)){
        draw_sprite(marcapieza,numeros[prov%10+1],(3-i)*tama/2,
          (cont_marcapieza)*tama/8);
        draw_sprite(marcapieza,numeros[prov2%10+1],(3-i)*tama/2,
          (cont_marcapieza-8)*tama/8);
      }
      prov/=10;
      prov2/=10;
      if(prov==prov2)break;
    }else for(i=1;i<=3;i++){
      if((prov%10)!=(prov2%10)){
        draw_sprite(marcapieza,numeros[prov%10+1],(3-i)*tama/2,
          (-cont_marcapieza)*tama/8);
        draw_sprite(marcapieza,numeros[prov2%10+1],(3-i)*tama/2,
          (8-cont_marcapieza)*tama/8);
      }
      prov/=10;
      prov2/=10;
      if(prov==prov2)break;
    }
    cont_marcapieza++;
  }
  if(cont_marcapieza>8){
    pieza_ant=pieza_nuevo;
    cont_marcapieza=0;
    blit(marcapieza,intermedio,0,0,ancini+tama*33/2,tama*11,marcapieza->w,
      marcapieza->h);
    blit(marcapieza,fondo,0,0,ancini+tama*33/2,tama*11,marcapieza->w,
      marcapieza->h);
   }
}

void destruye_marcapieza(void){
  destroy_bitmap(marcapieza);
}

void prepara_marcador(void){
  BITMAP *temp;
  int i;

  temp=create_bitmap(8,8);
  numeros[0]=create_bitmap(tama/2,tama);
  clear_to_color(numeros[0],colortrans);
  for(i=1;i<=10;i++){
    numeros[i]=create_bitmap(tama/2,tama);
    clear_to_color(numeros[i],makecol(40,40,60));
    clear_to_color(temp,makecol(200,20,20));
    textprintf(temp,font,0,0,3,"%i",i-1);
    stretch_blit(temp,numeros[i],0,0,8,8,tama/8,tama/8,tama/4,3*tama/4);
  }
  destroy_bitmap(temp);
  marcador=create_bitmap(3*tama,tama);
  clear_to_color(marcador,makecol(20,20,20));
  draw_sprite(marcador,numeros[1],5*tama/2,0);
  //draw_sprite(marcador,numeros[1],4*tama/2,0);
  cont_marcador=0;
  punt_ant=0;
  punt_nuevo=0;
  blit(marcador,intermedio,0,0,ancini+tama*15,tama*9,marcador->w,marcador->h);
  blit(marcador,fondo,0,0,ancini+tama*15,tama*9,marcador->w,marcador->h);
}

void calcula_marcador(void){
  int i,prov,prov2,base;
  if(cont_marcador==0){
    if(puntos!=punt_nuevo){
      prov=puntos;
      prov2=punt_nuevo;
      base=1;
      for(i=1;i<=8;i++){
        if((prov%10)!=(prov2%10)){
            punt_nuevo+=base;
            if(prov2%10==9)punt_nuevo-=base*10;
          }
        prov/=10;
        prov2/=10;
        base*=10;
        if(prov==prov2)break;
      }
      cont_marcador=1;
    }
  }else{
   /*textprintf(intermedio,font,100,32,1,"%i,%i:%i",punt_ant,punt_nuevo,puntos);
   refresca();
   borra(100,32,300,30);
   while (keypressed())readkey();
   while (!keypressed());
   while (keypressed())readkey();*/
    prov=punt_ant;
    prov2=punt_nuevo;
    for(i=1;i<=8;i++){
      if((prov%10)!=(prov2%10)){
        draw_sprite(marcador,numeros[prov2%10+1],(6-i)*tama/2,
          (8-cont_marcador)*tama/8);
        draw_sprite(marcador,numeros[prov%10+1],(6-i)*tama/2,
          (-cont_marcador)*tama/8);
      }
      prov/=10;
      prov2/=10;
      if(prov==prov2)break;
    }
    cont_marcador++;
  }
  if(cont_marcador>8){
    punt_ant=punt_nuevo;
    cont_marcador=0;
    blit(marcador,intermedio,0,0,ancini+tama*15,tama*9,marcador->w,marcador->h);
    blit(marcador,fondo,0,0,ancini+tama*15,tama*9,marcador->w,marcador->h);
  }
}

void destruye_marcador(void){
  int i;

  for(i=0;i<=10;i++){
    destroy_bitmap(numeros[i]);
  }
  destroy_bitmap(marcador);
}

void prepara_efectos(void){
  prepara_marcador();
  //prepara_marcapunt();
  //prepara_marcapieza();
  prepara_marcaltura();
  prepara_marcatiemp();
  prepara_estrellas();
  prepara_puntos();
}

void destruye_efectos(void){
  destruye_marcador();
  //destruye_marcapunt();
  //destruye_marcapieza();
  destruye_marcaltura();
  destruye_marcatiemp();
  destruye_estrellas();
  destruye_puntos();
}

extern void calcula_efectos(void){
  calcula_marcador();
  //calcula_marcapunt();
  //calcula_marcapieza();
  calcula_marcaltura();
  if(Lestrella!=NULL)calcula_estrellas();
  if(Lpuntos!=NULL)calcula_puntos();
  if(tiempo>t_representado)calcula_marcatiemp();
}
extern void pinta_efectos(void){
  struct Testrella *etemp;
  struct Tpuntos *ptemp;
  if(cont_marcador!=0){
    blit(marcador,intermedio,0,0,ancini+tama*15,tama*9,marcador->w,marcador->h);

  }
  /*if(cont_marcapunt!=0){
    blit(marcapunt,intermedio,0,0,ancini+tama*15,tama*11,marcapunt->w,
      marcapunt->h);
  }*/
  /*if(cont_marcapieza!=0){
    blit(marcapieza,intermedio,0,0,ancini+tama*33/2,tama*11,marcapieza->w,
      marcapieza->h);
  }*/
  pinta_marcaltura();
  for(etemp=Lestrella;etemp!=NULL;etemp=etemp->siguiente)
    masked_blit(Gestrella,intermedio,0,0,(etemp->x)/200,(etemp->y)/200,tama/8,
      tama/8);
  for(ptemp=Lpuntos;ptemp!=NULL;ptemp=ptemp->siguiente)
    masked_blit(ptemp->valor,intermedio,0,0,ptemp->x,ptemp->y,24,8);
}
extern void borra_efectos(void){
  struct Testrella *etemp;
  struct Tpuntos *ptemp;
  for(etemp=Lestrella;etemp!=NULL;etemp=etemp->siguiente)
    borra((etemp->x)/200,(etemp->y)/200,tama/8,tama/8);
  for(ptemp=Lpuntos;ptemp!=NULL;ptemp=ptemp->siguiente)
    borra(ptemp->x,ptemp->y,24,8);
  borra_marcaltura();
  //borra(ancini+tama*15,tama*9,marcador->w,marcador->h);
}

