#include <allegro.h>
#include "effects.h"

pixelz pixel[MAX_PIXELS];

void init_pixel(int _x, int _y, int _x_vel, int _y_vel, int _color)
 {
 int z;
 for (z=0;z<MAX_PIXELS;z++) 
		{
          if (pixel[z].state==0)
			   {
                  pixel[z].state=1;//bullet is alive
                  pixel[z].x=_x;
                  pixel[z].y=_y;
                  pixel[z].x_vel = _x_vel;
                  pixel[z].y_vel = _y_vel;
                  pixel[z].color = _color;
                  pixel[z].counter = 0;
                  break;
		       } 
		}

  }       


void move_pixels()
{
  for(int z = 0; z < MAX_PIXELS; z++)
   if(pixel[z].state == 1)
    {
      pixel[z].x+=pixel[z].x_vel;
      pixel[z].y+=pixel[z].y_vel;
      pixel[z].counter += ABS(pixel[z].y_vel); 
      pixel[z].counter += ABS(pixel[z].x_vel);
        if(pixel[z].counter > SCREEN_W)
          pixel[z].state = 0;
        if(pixel[z].x_vel  == 0 && pixel[z].y_vel == 0)
            pixel[z].x_vel = pixel[z].y_vel = rand()% 10;
    } 
}

void draw_pixels(BITMAP *bmp)
{
  for(int z = 0; z < MAX_PIXELS; z++)
     if(pixel[z].state == 1)
       putpixel(bmp,pixel[z].x,pixel[z].y, pixel[z].color);
}




void lightning_helper(BITMAP *bmp, int x, int y, int d) 
{
	circlefill(bmp, x, y, 3, d);
	circlefill(bmp, x, y, 2, d+5);
}
 void draw_lightning(BITMAP *bmp, int x1, int y1, int x2, int y2, int c) 
{
	int i;
	int x[10];
	int y[10];
	int dx = (x2-x1)/8;
	int dy = (y2-y1)/8;
	int var = (MAX(abs(x2-x1),abs(y2-y1)) / 5);

	if(var == 0) var = 1;
	if(var > 10) var = 10;

	x[0] = x1;
	y[0] = y1;
	x[9] = x2;
	y[9] = y2;

	for(i=1; i<9; i++) 
	{
		x[i] = x1+(dx*i) - (var>>1) + (rand()%var);
		y[i] = y1+(dy*i) - (var>>1) + (rand()%var);
	}

	for(i=0; i<9; i++)
		do_line(bmp, x[i], y[i], x[i+1], y[i+1], c, lightning_helper);
	
	for(i=0; i<9; i++)
		line(bmp, x[i], y[i], x[i+1], y[i+1], 15);
}//end draw lightning

 int Random(int u)
{
    return (rand() % u);
}
 void drawBackground(BITMAP *bmp, int num)
{
    int b1,b2,d1=16,d2=16;
    clear_to_color(bmp,makecol(255,255,255));
    for (int j=0; j<SCREEN_H; j++)
    {
        for (int i=0; i<SCREEN_W; i++)
        {   
            b1=192+d1;
            b2=128+d2;
            if (b1<128) b1=128;
            if (b1>255) b1=255;
            if (b2<128) b2=128;
            if (b2>255) b2=255;
            if (Random(1000)>950) d1=-d1;
            if (Random(1000)>950) d2=-d2;
            putpixel(bmp,i,j,makecol(num-b1,num+b2,num));
        }
    }
}

int distance(int x1,int y1,int x2,int y2)
{
    int sx=ABS(x2-x1),sy=ABS(y2-y1);

    return fixtoi(fhypot(itofix(sx),itofix(sy)));
}


void drawMouse(BITMAP *bmp,int x, int y)
{
    int c,r,d,g,b, SIZE = 10;    

    for (int i=-(SIZE-1); i<SIZE; i++)
    {
        for (int j=-(SIZE-1); j<SIZE; j++)
        {   
            d=distance(i,j,0,0);
            if (d<SIZE)
            {
                c=getpixel(bmp,x+i,y+j);
                r=(getr(c)*d)/SIZE;
                g=getg(c);
                b=getb(c);
                if (b>0)
                {
                    b=g=(b*r)/255;
                }
                c=makecol(r,b,g);
                putpixel(bmp,x+i,y+j,c);
            }
        }
    }
}

char get_keyboard_input(char words[], int max_length, int delay = 0)
{
static int	key_delay=0;
	int length, key;

  if(delay > 0)
	if(key_delay > 0)
	{
		clear_keybuf();
		key_delay--;
	}

	if(keypressed())
	{
		length = strlen(words);
		key = (readkey() & 0xff);

		if(key == 8 && length > 0)
		{
			words[length-1] = '\0';
		}
		else if(key != 10 && key != 13 && key != 27 && length < max_length)
		{
			words[length] = (char)key;
		//	words[length+1] = '|';//lets make a cursor!!
			words[length+1] = '\0';
			if(delay > 0)
            key_delay = delay;//used to be 3
		}
	}
 }//end key press fn
 
 void tech_print(BITMAP *tmp, char *words)
 {
 /* int WIDTH = 8
  int VERTICALPOS = 5;
  int COLOR = 7;
  int SIZEOFTEXT = 10;
  int i;
   
  char cache[2];
  for(i=0;i<strlen(ch);i++)
  {
   cache[0]words[i];
   cache[1]=NULL;
   textout(tmp,font,cache,(i%WIDTH)*(SIZEOFTEXT),(VERTICALPOS)+(SIZEOFTEXT)*(i/WIDTH),(COLOR));
/////  play_sample((TYPINGSOUND),128,128,1000,0);
  rest(100);
 }*/
}
void Prepare_rotate_palette(PALETTE *palette)
{
  int c;
  
   
     for (c=0; c<64; c++) {
      palette[c]->r = c;
      palette[c]->g = 0;
      palette[c]->b = 0;
   }
   for (c=64; c<128; c++) {
      palette[c]->r = 127-c;
      palette[c]->g = c-64;
      palette[c]->b = 0;                 
   }
   for (c=128; c<192; c++) {
      palette[c]->r = 0;
      palette[c]->g = 191-c;
      palette[c]->b = c-128;
   }
   for (c=192; c<256; c++) {
      palette[c]->r = 0;
      palette[c]->g = 0;
      palette[c]->b = 255-c;
   }
}

void rotate_pallette(PALETTE palette)
{
    RGB temp;
    int c;
    
    temp = palette[255];
      for (c=255; c>0; c--)
	   palette[c] = palette[c-1];
     palette[0] = temp;
     set_palette(palette);
}
