#include <stdio.h>
#include <libnet.h>
#include "network.h"

/* Use the driver of your choice.
 * e.g. NET_DRIVER_WSOCK_WIN under Windows.  */
 
 NET_CONN *listen;
 NET_CONN *client_conn[MAX_CLIENTS];
 NET_CONN *server_conn;
 
 
 int client_num = 0;
 bool connected = false;
 int client_conn_state[MAX_CLIENTS];
 int server_conn_state;
 
void Init_network_stuff(void)
{
    net_init ();
    net_loadconfig (NULL);
    
    net_detectdrivers (net_drivers_all);
    net_initdrivers (net_drivers_all);
    
}

// Send_data
 // net_send_rdm (the_conn, data, sizeof(data));

/*
 Get_data

  // Check if the remote side sent us any messages.  
     while (net_query_rdm (the_conn))
     
            // If so, receive them and print them out.  
        if (net_receive_rdm (the_conn, holding_data, sizeof holding_data) > 0)
         return 1;
*/

int Server_init(void)
{
     //If we are the server, open a listening conn and wait
     // for a client.  
        listen = net_openconn (DRIVER, "");
        if (!listen) 
            return 1; //("Error opening conn.");
        
        if (net_listen (listen) != 0) 
            return 2; //puts ("Error making conn listen.");
            
        for(int n = 0; n < MAX_CLIENTS; n++)
         client_conn_state[n] = 0;
        return 0;    
}

int Sever_listen_for_new_client(void)
{
         client_conn[client_num] = net_poll_listen (listen);
        if(client_conn[client_num])
        {
        client_num++;
        return 1;
        }
        
        if(client_num >= MAX_CLIENTS)
        net_closeconn (listen);
}

void Server_close_client_conn(int client)
{
  	if(client_conn[client_num]) 
      net_closeconn(client_conn[client_num]);
	client_conn[client_num]= NULL;
}


/* Server_broadcast(void *data) 
 
	for(int n = 0; n < client_num; n++) 
		if(client_conn[client_num]) 
			net_send_rdm(client_conn[client_num], data, sizeof(data));
*/

void Server_exit(void) 
 {
	for(int n = 0; n < client_num; n++) 
	  if(client_conn[client_num]) net_closeconn(client_conn[client_num]);

	if(listen) 
     net_closeconn(listen);
	listen = NULL;
}

int Client_init(char *ip_address)
{
  int status;

        /* If we are the client, open a conn and connect to the
         * server's listening conn.  */
        server_conn = net_openconn (DRIVER, NULL);
        if (!server_conn) 
            return 1; //puts ("Error opening conn.");
           
        if (net_connect (server_conn, ip_address) != 0) 
            return 2; //puts ("Error initiating connection.");
            
        //"Connecting..."
        do status = net_poll_connect (server_conn);
        while (status == 0);

        if (status < 0) 
            return 3; //puts ("Error connecting.");
     
     server_conn_state = 0;
     return 0;           
}

void Client_exit(void)
{
  	if(server_conn) 
      net_closeconn(server_conn);
	server_conn = NULL;
	connected = false;
}

     


