/* Demonstrates the conn functions.  This example was adapted
 * from the channel example.  */

#include <stdio.h>
#include <string.h>
#include <libnet.h>
#include <allegro.h>
#include "main.h"
#include "chat_it.h"
#include "menu.h"

DATAFILE *data;
BITMAP *buffer;
BITMAP *background;

bool mus_ok = true;
bool sound_ok = true;
bool exit_prog = false;
int program_state = MENU;


volatile int speed_counter;
volatile int timer_1;
volatile int timer_2;
volatile int fps;
volatile int frame_counter;    

void fps_proc() //this counts frame rate
{
	fps = frame_counter;
 frame_counter = 0;
}END_OF_FUNCTION(fps_proc);

void increment_speed_counter() 
{ 
speed_counter++; 
}
END_OF_FUNCTION(increment_speed_counter);

void inc_timer_1()
{
   timer_1++;
}

END_OF_FUNCTION(inc_timer_1);  
void inc_timer_2()
{
   timer_2++;
}

END_OF_FUNCTION(inc_timer_2);


int main (void)
{
    
//win_set_wnd_create_proc(HWND (*proc)(WNDPROC));
            
    allegro_init();                           
    install_timer();                            
    install_keyboard();  
    
 //   install_mouse();     

    
    
  if(install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL) != 0)
   { 
    printf("Error setting up Sound, so the game will be silent!\n%s\n", allegro_error);
    sound_ok = false;
   }
  
  
  if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0)!=0)
   {
        // otherwise full screen will do
        if (set_gfx_mode(GFX_AUTODETECT,640,480,0,0)!=0)
        {
            allegro_message("Unable initialize graphics module\n%s\n", allegro_error);
            exit(-1);
        }
   }
   	
   data = load_datafile("data.dat");
  
	if (!data) {                               
		allegro_message("Error loading data file.\n");
		exit(-1);
	}    
  
  	set_window_title("Jus' Chattin'");
 
        //make game run in background
    	if(set_display_switch_mode(SWITCH_BACKGROUND))
		set_display_switch_mode(SWITCH_BACKAMNESIA); 
		
LOCK_VARIABLE(speed_counter);
LOCK_VARIABLE(timer_1);  
LOCK_VARIABLE(timer_2); 
LOCK_VARIABLE(fps);
LOCK_VARIABLE(frame_counter);

LOCK_FUNCTION(inc_timer_1);
LOCK_FUNCTION(increment_speed_counter); 
LOCK_FUNCTION(inc_timer_2);
LOCK_FUNCTION(fps_proc);

install_int(inc_timer_1, 10);// every second    //ever 10 of a sec 
install_int_ex(inc_timer_2, SECS_TO_TIMER(1));   //every sec
install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
install_int(fps_proc, 1000);  

   
   buffer = create_bitmap(SCREEN_W,SCREEN_H);
   background = create_bitmap(SCREEN_W,SCREEN_H);
   clear(buffer);
   clear(background);	
   clear(screen); 
 
 //////////////////////////////////////////////////////////////////////////////////////////
    do{                                        
  switch(program_state)                             
   {                                                
     case MENU: 
         clear(buffer); 
        clear(screen);    
       menu_interface();
     break;                                                
  
     case CHAT:                                 
      chat_prog(super_chat_type);
     break;                                   
  
     case EXIT:
       unload_datafile(data);   
       destroy_bitmap(buffer);    
       destroy_bitmap(background);                
       allegro_exit();
       
       exit_prog = TRUE;
     break;
   }//end switch
  }while(!exit_prog);
 
    
    /* Quit.  */
    return 0;
}
END_OF_MAIN();

