#include <libamp.h>
#include "common.h"
#include "key_name.h"


char *sensitivity_menu[] = {
"Adjust Keyboard Sensitivity",
"Player 1",
"X speed :     ",
"Y speed :     ",
"Rotate speed :    ",
" ",
"Player 2",
"X speed :     ",
"Y speed :     ",
"Rotate speed :    ",
"\001"
};

char *tetris_main_menu[] = {
"Main Menu",
"Play Tetris",
"Options",
"Hall Of Fame",
"Exit",
"Resume Game",
"\000"
};

char *select_no_player_menu[] = {
"Select Number of Player",
"1 Player",
"2 Players",
"\000"
};

char *tetris_exit_game[] = {
"Exit to Menu ?",
"No",
"Yes",
"\000"
};

char *exit_menu[] = {
"                                                             ",
"                                               ",
"                                               ",
"                                               ",
"\000"
};

char *pause_menu[] = {
"Press F9 to continue",
"\000"
};

char *define_keys_menu[] = {
"Select Player Mode",
"1 Player Mode",
"2 Players Mode",
"\000"
};

char *options_menu[] = {
"Options Menu",
"Define Keys",
"Adjust Keyboard Sensitivity",
"Change Background : Off ",
"Music Order : Sequential ",
"Alpha Level : 100% ",
"Number of Voices : 32  ",
"Sfx Volume : 100% ",
"Music Volume : 100% ",
"\000"
};

char *select_level_menu[] = {
"Select a Level",
"0",
"1",
"2",
"3",
"4",
"5",
"6",
"7",
"8",
"9",
"10",
"11",
"12",
"13",
"14",
"\000"
};

char *define_1p_menu[] = {
"Define Keys Menu",
"PLAYER 1",
"Left :                     ",
"Right :                    ",
"Down :                     ",
"Rotate  :                 ",
"Rotate  :                 ",
"\001"
};

char *undefined_keys_menu[] = {
"Some Keys Are Undefined",
"Please define it",
"\000"
};

char *define_2p_menu[] = {
"Define Keys Menu",
"PLAYER 1",
"Left :                     ",
"Right :                    ",
"Down :                     ",
"Rotate  :                 ",
"Rotate  :                 ",
" ",
"PLAYER 2",
"Left :                     ",
"Right :                    ",
"Down :                     ",
"Rotate  :                 ",
"Rotate  :                 ",
"\001"
};

char *select_height_menu[] = {
"Select a Height",
"0",
"1",
"2",
"3",
"4",
"5",
"6",
"7",
"8",
"9",
"10",
"11",
"12",
"13",
"14",
"\000"
};


char *fame_menu[] = {
    "Hall Of Fame                               ",
    "    Name                     Lines    Score",
    "1 . Guan Foo Wah              120      1700",
    "2 .                                        ", 
    "3 .                                        ",
    "4 .                                        ", 
    "5 .                                        ",  
    "6 .                                        ",
    "7 .                                        ", 
    "8 .                                        ", 
    "9 .                                        ", 
    "10.                                        ", 
    "\000"
    };


// count no of strings in an array of strings
int count_no_strings (char **the_string)
{
    int no_string = 0;

    while (the_string[no_string][0] >= 32)
        no_string++;

    return no_string;
}

// draw the layout of the menu
void draw_menu (BITMAP *source, BITMAP *dest, MENU_DIM *mn, char **the_menu, int bar_thickness, FONT *title, FONT *normal_font, int highlight=TRUE, void (*callfunc)(BITMAP *source, char **the_menu, MENU_DIM *mn), int fade_color)
{
    int no_strings;
    int height=0, width=0;
    int x1, y1;
    int counter;
    int curr_y;
    FONT *temp_font;
    BITMAP *temp_bitmap;

    no_strings = mn->no_strings = count_no_strings (the_menu);

    // find the height of the menu in pixels
    height = text_height (title) * bar_thickness;
    height += text_height(normal_font) * (no_strings - bar_thickness);

    // find the width of the menu in pixels    
    for (counter=0; counter<no_strings; counter++)
        {
        if (counter < bar_thickness)
            temp_font = title;
        else
            temp_font = normal_font;

        if ( text_length (temp_font, the_menu[counter])  > width  )
            width = text_length (temp_font, the_menu[counter]);
        }

    width += 30;
    if (no_strings != bar_thickness)
        height += 10;

    mn->width = width;
    mn->width = height;
    mn->bar_thickness = bar_thickness;
    mn->normal_font = normal_font;
    mn->title_font = title;
    mn->the_menu = the_menu;
    
    // find the upper left corner of the menu
    x1 = mn->x1 = SCREEN_W/2 - width/2;
    y1 = mn->y1 = SCREEN_H/2 - height/2;

    temp_bitmap = create_bitmap (width+1, height+1);
    if (temp_bitmap == NULL)
        exiting_error ("Error : Unable to allocate temporary bitmap buffer\n");

    
    // save the background before any modifications later
    blit (source, temp_buffer, x1, y1, 0, 0, width+1, height+1);    

    // draw the semi transparent background
    clear (temp_bitmap);
    draw_trans_sprite (temp_bitmap, temp_buffer, 0,0);
    blit (temp_bitmap, source, 0,0, x1, y1, width+1, height+1);


    // now draw the box
    draw_box (source, x1, y1, x1 + width, y1 + height, makecol (255,255,255));

    // draw the blue bar
    hline (source, x1+1, y1+text_height(title)*bar_thickness, x1+width-1, makecol (255,255,255));
    for (counter=1; counter < text_height(title) * bar_thickness; counter++)
        hline (source, x1+1, y1+counter, x1+width-1, menu_bar_color);

    // print the title
    temp_font = title;
    for (counter=0; counter<bar_thickness; counter++)
        textout_centre(source, temp_font, the_menu[counter], SCREEN_W/2, y1 + counter * text_height(title), menu_for_color);

    // print the options
    temp_font = normal_font;
    curr_y = mn->opt_y1 = y1 + 5 + (bar_thickness * text_height(title));
    for (counter=bar_thickness; counter<no_strings; counter++)
        textout_centre(source, temp_font, the_menu[counter], SCREEN_W/2, curr_y + (counter-bar_thickness) * text_height(normal_font), fade_color);

    // highlight the option ??
    if (highlight == TRUE)
        {
        counter = the_menu[no_strings][0] + bar_thickness;
        textout_centre(source, temp_font, the_menu[counter], SCREEN_W/2, curr_y + (counter-bar_thickness) * text_height(normal_font), menu_for_color);
        }

    if (callfunc != NULL)
        callfunc (source, the_menu, mn);

    // copy the modified background to dest
    blit (source, dest, 0,0,0,0, SCREEN_W, SCREEN_H);

    // now restore the background
    blit (temp_buffer, source, 0, 0, x1, y1, width+1, height+1);
    destroy_bitmap (temp_bitmap);
}

// decides the event in a menu according to user's keyboard input
int manage_menu (BITMAP *dest, MENU_DIM *mn, void (callfunc)(int* curr_opt, int old_opt) )
{
    int curr_opt;
    int old_opt;
    int key_buffer;

    curr_opt = mn->the_menu[mn->no_strings][0];

    while (1)
        {
        clear_keybuf();
        key_buffer = jg_readkey();

        old_opt = curr_opt;
        if ( (key_buffer >> 8) == KEY_UP)
            {
            curr_opt--;
            if (curr_opt < 0)
                curr_opt = mn->no_strings - mn->bar_thickness - 1;

            mn->the_menu[mn->no_strings][0] = (char) curr_opt;
            }

        else if ( (key_buffer >> 8) == KEY_DOWN)
            {
            curr_opt++;
            if (curr_opt > mn->no_strings - mn->bar_thickness - 1)
                curr_opt = 0;

            mn->the_menu[mn->no_strings][0] = (char) curr_opt;
            }
        else if ( (key_buffer >> 8) == KEY_LEFT)
            return (-100 - curr_opt);

        else if ( (key_buffer >> 8) == KEY_RIGHT)
            return (-200 - curr_opt);

        else if ( (key_buffer >> 8) == KEY_ENTER)
            {
            while (key[KEY_ENTER]){};
            return curr_opt;
            }

        else if ( (key_buffer >> 8) == KEY_ESC)
            return -1;

        if (callfunc != NULL)
            callfunc (&curr_opt, old_opt);

        mn->the_menu[mn->no_strings][0] = (char) curr_opt;

        // highlight new option
        if (old_opt != curr_opt)
            {
            textout_centre(dest, mn->normal_font, mn->the_menu[curr_opt + mn->bar_thickness], SCREEN_W/2, mn->opt_y1 + (curr_opt) * text_height(mn->normal_font), menu_for_color);
            textout_centre(dest, mn->normal_font, mn->the_menu[old_opt + mn->bar_thickness], SCREEN_W/2, mn->opt_y1 + (old_opt) * text_height(mn->normal_font), menu_fade_color);
            }
        }

    return 0;
}

// use to get the scancode of a key user is currently pressing
int get_defined_key(void)
{
    int scan=0;

    while (1)
        {
        if (key[scan])      // key array is an Allegro array
            {
            if (scan >= KEY_F1 && scan <= KEY_F10);
            else if (scan == KEY_F11 || scan == KEY_F12);
            else if (scan == KEY_ESC);
            else return scan;
            }

        scan++;
        if (scan >= KEY_MAX)
            scan = 1;       // no keypress. Restart the search
        }
}

// checked if there is any keys defined the same and then clear it.
void test_conflict_keys (PLAYER_KEYS *pkeys, int element, int max)
{
    int index;

    for (index=0; index < max; index++)
        {
        if (index == element)
            continue;

        if (pkeys->p[element] == pkeys->p[index])
            pkeys->p[index] = 0;    // same keys found. Clear it
        }
}

// check any keys which is undefined. Returs true if true. Else false
int check_any_undefined_keys (PLAYER_KEYS *pkeys, int max)
{
    int index;

    for (index=0; index < max; index++)
        if (pkeys->p[index] == 0)
            return TRUE;

    return FALSE;
}

// passed as a parameter for manage_menu(). Just to make sure than when
// defining keys for 1 player mode, the "Player 1" string is not selected
// or highlighted.
void manage_1p_menu (int *curr_opt, int old_opt)
{
    if (*curr_opt == 0)
        {
        if (old_opt == 1)
            *curr_opt = 5;
        else
            *curr_opt = 1;
        }
}

// passed as a parameter for manage_menu(). Just to make sure than when
// defining keys for 1 player mode, the "Player 1" and a few other string is
// not selected or highlighted.
void manage_2p_menu (int *curr_opt, int old_opt)
{
    if (*curr_opt == 0)
        {
        if (old_opt == 1)
            *curr_opt = 12;
        else
            *curr_opt = 1;
        }
    else if (*curr_opt == 6)
        {
        if (old_opt == 5)
            *curr_opt = 8;
        }
    else if (*curr_opt == 7)
        {
        if (old_opt == 8)
            *curr_opt = 5;
        }
}

// pass as a parameter for draw_menu(). Used to make sure that in define keys
// for 1 player mode, the string "Player 1" is always highlighted
void draw_1p_menu (BITMAP *source, char **the_menu, MENU_DIM *mn)
{
    textout_centre(source, font, the_menu[1], SCREEN_W/2, mn->opt_y1 + (1- mn->bar_thickness) * text_height(font), menu_for_color);
}

// pass as a parameter for draw_menu(). Used to make sure that in define keys
// for 2 player mode, the strings "Player 1" and "Player 2" are always
// highlighted
void draw_2p_menu (BITMAP *source, char **the_menu, MENU_DIM *mn)
{
    textout_centre(source, font, the_menu[1], SCREEN_W/2, mn->opt_y1 + (1 - mn->bar_thickness) * text_height(font), menu_for_color);
    textout_centre(source, font, the_menu[8], SCREEN_W/2, mn->opt_y1 + (8 - mn->bar_thickness) * text_height(font), menu_for_color);
}

// pass as a parameter for draw_menu(). 
// To make sure that the player scores are always highlighted when game over
void draw_game_over_menu (BITMAP *source, char **the_menu, MENU_DIM *mn)
{
    textout_centre(source, font, the_menu[1], SCREEN_W/2, mn->opt_y1 + (1 - mn->bar_thickness) * text_height(font), menu_for_color);
    if (the_menu[2][0] != NULL)
        textout_centre(source, font, the_menu[2], SCREEN_W/2, mn->opt_y1 + (2 - mn->bar_thickness) * text_height(font), menu_for_color);
}

// handles the events in define keys in one player mode
void do_define_1p_menu()
{
    MENU_DIM define_1p_menu_dim;
    int result;

    while (1)
        {
        sprintf (define_1p_menu[2], "Left : %s", key_name[ player_keys[0].p[kleft] ]);
        sprintf (define_1p_menu[3], "Right : %s", key_name[ player_keys[0].p[kright] ]);
        sprintf (define_1p_menu[4], "Down : %s", key_name[ player_keys[0].p[kdown] ]);
        sprintf (define_1p_menu[5], "Rotate  : %s", key_name[ player_keys[0].p[kccw] ]);
        sprintf (define_1p_menu[6], "Rotate  : %s", key_name[ player_keys[0].p[kcw] ]);

        draw_menu (curr_background, screen, &define_1p_menu_dim, define_1p_menu, 1, font, font, TRUE, draw_1p_menu);
        result = manage_menu (screen, &define_1p_menu_dim, manage_1p_menu);

        if (result == 1)
            {
            sprintf (define_1p_menu[2], "Left : ");
            draw_menu (curr_background, screen, &define_1p_menu_dim, define_1p_menu, 1, font, font, TRUE, draw_1p_menu);
            player_keys[0].p[kleft] = get_defined_key();
            test_conflict_keys(&player_keys[0], kleft, 5);
            }
        else if (result == 2)
            {
            sprintf (define_1p_menu[3], "Right : ");
            draw_menu (curr_background, screen, &define_1p_menu_dim, define_1p_menu, 1, font, font, TRUE, draw_1p_menu);
            player_keys[0].p[kright] = get_defined_key();
            test_conflict_keys(&player_keys[0], kright, 5);
            }
        else if (result == 3)
            {
            sprintf (define_1p_menu[4], "Down : ");
            draw_menu (curr_background, screen, &define_1p_menu_dim, define_1p_menu, 1, font, font, TRUE, draw_1p_menu);
            player_keys[0].p[kdown] = get_defined_key();
            test_conflict_keys(&player_keys[0], kdown, 5);
            }
        else if (result == 4)
            {
            sprintf (define_1p_menu[5], "Rotate  : ");
            draw_menu (curr_background, screen, &define_1p_menu_dim, define_1p_menu, 1, font, font, TRUE, draw_1p_menu);
            player_keys[0].p[kccw] = get_defined_key();
            test_conflict_keys(&player_keys[0], kccw, 5);
            }
        else if (result == 5)
            {
            sprintf (define_1p_menu[6], "Rotate %c : ", 0x80);
            draw_menu (curr_background, screen, &define_1p_menu_dim, define_1p_menu, 1, font, font, TRUE, draw_1p_menu);
            player_keys[0].p[kcw] = get_defined_key();
            test_conflict_keys(&player_keys[0], kcw, 5);
            }
        else if (result == -1)
            {
            if (check_any_undefined_keys(&player_keys[0], 5) == FALSE)
                return;
            else
                {
                MENU_DIM undefined_keys_menu_dim;
                draw_menu (curr_background, screen, &undefined_keys_menu_dim, undefined_keys_menu, 2, font, font);
                jg_readkey();
                }
            }
        }
}

// handles the events in define keys menu in two player mode
void do_define_2p_menu()
{
    MENU_DIM define_2p_menu_dim;
    int result;

    while (1)
        {
        sprintf (define_2p_menu[2], "Left : %s", key_name[ player_keys[1].p[kleft] ]);
        sprintf (define_2p_menu[3], "Right : %s", key_name[ player_keys[1].p[kright] ]);
        sprintf (define_2p_menu[4], "Down : %s", key_name[ player_keys[1].p[kdown] ]);
        sprintf (define_2p_menu[5], "Rotate  : %s", key_name[ player_keys[1].p[kccw] ]);
        sprintf (define_2p_menu[6], "Rotate  : %s", key_name[ player_keys[1].p[kcw] ]);

        sprintf (define_2p_menu[9], "Left : %s", key_name[ player_keys[1].p[5+kleft] ]);
        sprintf (define_2p_menu[10],"Right : %s", key_name[ player_keys[1].p[5+kright] ]);
        sprintf (define_2p_menu[11],"Down : %s", key_name[ player_keys[1].p[5+kdown] ]);
        sprintf (define_2p_menu[12],"Rotate  : %s", key_name[ player_keys[1].p[5+kccw] ]);
        sprintf (define_2p_menu[13],"Rotate  : %s", key_name[ player_keys[1].p[5+kcw] ]);

        draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
        result = manage_menu (screen, &define_2p_menu_dim, manage_2p_menu);

        if (result == 1)
            {
            sprintf (define_2p_menu[2], "Left : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[kleft] = get_defined_key();
            test_conflict_keys(&player_keys[1], kleft, 10);
            }
        else if (result == 2)
            {
            sprintf (define_2p_menu[3], "Right : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[kright] = get_defined_key();
            test_conflict_keys(&player_keys[1], kright, 10);
            }
        else if (result == 3)
            {
            sprintf (define_2p_menu[4], "Down : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[kdown] = get_defined_key();
            test_conflict_keys(&player_keys[1], kdown, 10);
            }
        else if (result == 4)
            {
            sprintf (define_2p_menu[5], "Rotate  : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[kccw] = get_defined_key();
            test_conflict_keys(&player_keys[1], kccw, 10);
            }
        else if (result == 5)
            {
            sprintf (define_2p_menu[6], "Rotate  : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[kcw] = get_defined_key();
            test_conflict_keys(&player_keys[1], kcw, 10);
            }
        else if (result == 8)
            {
            sprintf (define_2p_menu[9], "Left : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[5+kleft] = get_defined_key();
            test_conflict_keys(&player_keys[1], 5+kleft, 10);
            }
        else if (result == 9)
            {
            sprintf (define_2p_menu[10], "Right : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[5+kright] = get_defined_key();
            test_conflict_keys(&player_keys[1], 5+kright, 10);
            }
        else if (result == 10)
            {
            sprintf (define_2p_menu[11], "Down : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[5+kdown] = get_defined_key();
            test_conflict_keys(&player_keys[1], 5+kdown, 10);
            }
        else if (result == 11)
            {
            sprintf (define_2p_menu[12], "Rotate  : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[5+kccw] = get_defined_key();
            test_conflict_keys(&player_keys[1], 5+kccw, 10);
            }
        else if (result == 12)
            {
            sprintf (define_2p_menu[13], "Rotate  : ");
            draw_menu (curr_background, screen, &define_2p_menu_dim, define_2p_menu, 1, font, font, TRUE, draw_2p_menu);
            player_keys[1].p[5+kcw] = get_defined_key();
            test_conflict_keys(&player_keys[1], 5+kcw, 10);
            }
        else if (result == -1)
            {
            if (check_any_undefined_keys(&player_keys[1], 10) == FALSE)
                return;
            else
                {
                MENU_DIM undefined_keys_menu_dim;
                draw_menu (curr_background, screen, &undefined_keys_menu_dim, undefined_keys_menu, 2, font, font);
                jg_readkey();
                }
            }
        }
}

// handles the events in select define player mode keys menu for selecting
// which player mode to be defined
void do_define_keys_menu(void)
{
    MENU_DIM define_keys_menu_dim;
    int result;


    while (1)
        {
        font = (FONT *) datafile[PLAYER_FONT].dat;
        draw_menu (curr_background, screen, &define_keys_menu_dim, define_keys_menu, 1, font, font);
        result = manage_menu (screen, &define_keys_menu_dim);

        if (result == 0)
            do_define_1p_menu();
        else if (result == 1)
            do_define_2p_menu();
        else if (result == -1)
            return;
        }
}

// handles events when selecting how many players, levels and lines to be
// be played
void select_player (void)
{
    MENU_DIM select_no_player_dim;
    MENU_DIM select_level_dim;
    MENU_DIM select_height_dim;

    int player_con = TRUE;
    int level_con = TRUE;
    int height_con = TRUE;

    int result_player;
    int result_level;
    int result_height;

    while (player_con == TRUE)
        {
        font = (FONT *) datafile[PLAYER_FONT].dat;
        draw_menu (curr_background, screen, &select_no_player_dim, select_no_player_menu, 1, font, font);
        result_player = manage_menu (screen, &select_no_player_dim);

        if (result_player == 0 || result_player == 1)
            {
            level_con = TRUE;
            while (level_con == TRUE)
                {
                font = (FONT *) datafile[PLAYER_FONT].dat;
                draw_menu (curr_background, screen, &select_level_dim, select_level_menu, 1, font, font);
                result_level = manage_menu (screen, &select_level_dim);

                
                if ( (result_level >= 0) && (result_level <= 14) )
                    {
                    height_con = TRUE;
                    while (height_con == TRUE)
                        {
                        font = (FONT *) datafile[PLAYER_FONT].dat;
                        draw_menu (curr_background, screen, &select_height_dim, select_height_menu, 1, font, font);
                        result_height = manage_menu (screen, &select_height_dim);

                        if ( (result_height >= 0) && (result_height <= 14) )
                            {
                            resume_game = FALSE;
                            play_tetris (result_player + 1, result_level, result_height);
                            load_sequential_background ();
                            display_logo (curr_background);
                            play_music_name ("letsdanc.s3m");
                            player_con = FALSE;
                            level_con = FALSE;
                            height_con = FALSE;
                            }
                        else if (result_height == -1)
                            height_con = FALSE;
                        }
                    }
                else if (result_level == -1)
                    level_con = FALSE;

                }
            }

        else if (result_player == -1)
            player_con = FALSE;
        }

    return;
}

// handles events in the options menu
void do_options_menu (void)
{
    MENU_DIM options_menu_dim;
    int result;

    while (1)
        {
        if (change_background == TRUE)
            sprintf (options_menu[3], "Change Background : On");
        else
            sprintf (options_menu[3], "Change Background : Off");

        if (music_sequential == TRUE)
            sprintf (options_menu[4], "Music Order : Sequential");
        else
            sprintf (options_menu[4], "Music Order : Random");

        sprintf (options_menu[5], "Alpha Level : %d", 15 - alpha_level/17);
        sprintf (options_menu[6], "Number of Voices : %d", no_channels);
        sprintf (options_menu[7], "Sfx Volume : %d", sfx_volume/17);
        sprintf (options_menu[8], "Music Volume : %d", music_volume/17);
        

        font = (FONT *) datafile[PLAYER_FONT].dat;
        draw_menu (curr_background, screen, &options_menu_dim, options_menu, 1, font, font);
        result = manage_menu (screen, &options_menu_dim);

        if (result == 0)
            do_define_keys_menu();
        else if (result == 1)
            do_sensitivity_menu();

        else if ( (result == 2) || (result == -102) || (result == -202) )
            {
            if (change_background == TRUE)
                change_background = FALSE;
            else
                change_background = TRUE;
            }

        else if ( (result == 3) || (result == -103) || (result == -203) )
            {
            if (music_sequential == TRUE)
                music_sequential = FALSE;
            else
                music_sequential = TRUE;
            }

        else if ( (result == 4) || (result == -204) )
            {
            alpha_level -= 17;
            if (alpha_level < 0)
                alpha_level = 0;

            set_trans_blender (0, 0, 0, alpha_level);
            }
        else if ( result == -104 )
            {
            alpha_level += 17;
            if (alpha_level > 255)
                alpha_level = 255;

            set_trans_blender (0, 0, 0, alpha_level);
            }
        else if ( (result == 5) || (result == -205) || (result == -105) )
            {
            int temp;

            if ( (result == 5) || (result == -205) )
                {
                if (no_channels == 8)
                    no_channels = 16;
                else if (no_channels == 16)
                    no_channels = 32;
                else if (no_channels == 32)
                    no_channels = 64;
                else if (no_channels == 64)
                    no_channels = 8;
                }
            else
                {
                if (no_channels == 8)
                    no_channels = 64;
                else if (no_channels == 16)
                    no_channels = 8;
                else if (no_channels == 32)
                    no_channels = 16;
                else if (no_channels == 64)
                    no_channels = 32;
                }

            remove_mod();
            remove_sound ();

            reserve_voices (no_channels, -1);
            temp = install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL);
            if (temp < 0)
                {
                reserve_voices (-1, -1);
                temp = install_sound (DIGI_NONE, MIDI_NONE, NULL);
                if (temp < 0)
                    exiting_error ("Error : Unable to reinitialize sound card\n");
                }

            temp = install_mod (no_channels - no_sfx_channel);
            if (temp < 0)
                exiting_error ("Error : Unable to reinitialize JGMOD\n");

            play_mod(curr_mod, TRUE);
            }
        else if ( (result == 6) || (result == -206))
            {
            sfx_volume += 17;
            if (sfx_volume > 255)
                sfx_volume = 255;
            else
                play_sample ((SAMPLE *)datafile[ROTATE].dat, sfx_volume, 128, 1000, FALSE);
            }
        else if ( result == -106 )
            {
            sfx_volume -= 17;
            if (sfx_volume < 0)
                sfx_volume = 0;
            else
                play_sample ((SAMPLE *)datafile[ROTATE].dat, sfx_volume, 128, 1000, FALSE);
            }

        else if ( (result == 7) || (result == -207) )
            {
            music_volume += 17;
            if (music_volume > 255)
                music_volume = 255;

            set_mod_volume (music_volume);
            }
        else if ( result == -107)
            {
            music_volume -= 17;
            if (music_volume < 0)
                music_volume = 0;

            set_mod_volume (music_volume);
            }
        else if (result == -1)
            {
            save_config_cfg();
            return;
            }
        }
}

// handles the events in the confirmation of the user to exit this program.
// Always choose a random message in the menu when exiting.
int do_exit_menu (void)
{
    MENU_DIM exit_menu_dim;
    int result;
    int start;

    while (1)
        {
        start = make_random_exit_options ();

        font = (FONT *) datafile[PLAYER_FONT].dat;
        draw_menu (curr_background, screen, &exit_menu_dim, exit_menu, start, font, font);

        do{
        result = manage_menu (screen, &exit_menu_dim);
        }while (result < -1);

        if (result == 0 || result == 1)
            {
            if (result  == 1)
                {
                while (get_mod_volume())
                    {
                    set_mod_volume (get_mod_volume() - 1);
                    rest (6);
                    }

                play_sample ((SAMPLE *)datafile[ILBEBACK].dat, sfx_volume, 128, 1000, FALSE);
                rest (1800);
                }

            return result;
            }
        else if (result == -1)
            return result -1;
        }
}

// put the random message for used with do_exit_menu().
int make_random_exit_options (void)
{
    int ran;

    ran = random() % 6;

    if (ran == 0)
        {
        sprintf (exit_menu[0], "Winner Stays, Loser Quits");
        sprintf (exit_menu[1], "I am a winner");
        sprintf (exit_menu[2], "I am a loser");
        }
    else if (ran == 1)
        {
        sprintf (exit_menu[0], "Go Ahead. QUIT. See If I Care");
        sprintf (exit_menu[1], "Opps ! I'll stay");
        sprintf (exit_menu[2], "Quit");
        }
    else if (ran == 2)
        {
        sprintf (exit_menu[0], "Don't Go. Your OS isn't fun !");
        sprintf (exit_menu[1], "Stay");
        sprintf (exit_menu[2], "Quit");
        }
    else if (ran == 3)
        {
        sprintf (exit_menu[0], "Sure You Want to Exit This Fun Game ?");
        sprintf (exit_menu[1], "Stay");
        sprintf (exit_menu[2], "Exit");
        }
    else if (ran == 4)
        {
        sprintf (exit_menu[0], "Quit and I will format your hard disk");
        sprintf (exit_menu[1], "Show Mercy !! Don't !!");
        sprintf (exit_menu[2], "Quit and Format");
        }
    else if (ran == 5)
        {
        sprintf (exit_menu[0], "Exit and I will infect your computer with viruses");
        sprintf (exit_menu[1], "Ok ok... I stay");
        sprintf (exit_menu[2], "Infect");
        }

    exit_menu[3][0] = '\0';

    return 1;
}

// handles event in the confirmation of user for exiting from the game to the
// main menu
int do_exit_game_menu (int no_player)
{
    volatile TIMER temp_timer[max_player];
    MENU_DIM exit_game_menu;
    int x,y, x_pos, y_pos, random_block;
    int result;
    int player_no;

    copy_timer (temp_timer[0], timer[0]);   // backup timer first
    copy_timer (temp_timer[1], timer[1]);
    clear_old_game_space (0, -2);
    clear_old_game_space (1, -2);


    for (player_no=0; player_no < no_player; player_no++)
        {
        if (player[player_no].status != active)
            continue;

        for (x=0; x<game_window_width; x++)
            for (y=0; y<game_window_height; y++)
                {
                random_block = random () % max_block;
                x_pos = player[player_no].game_window_xpos + (x * block_width);
                y_pos = player[player_no].game_window_ypos + (y * block_height);

                blit ((BITMAP *)datafile[block[random_block].bitmap].dat, screen, 0,0,x_pos,y_pos, block_width, block_height);
                }
        }

    blit (screen, curr_background, 0,0,0,0, SCREEN_W, SCREEN_H);

    // wait until ESCAPE key is released
    while (key[KEY_ESC]){}

    font = (FONT *) datafile[PLAYER_FONT].dat;

    tetris_exit_game [count_no_strings(tetris_exit_game)][0] = '\0';
    while (1)
        {
        draw_menu (curr_background, screen, &exit_game_menu, tetris_exit_game, 1, font, font);
        result = manage_menu (screen, &exit_game_menu);

        if (result == 1)
            return result;

        while (key[KEY_ESC]){}
        blit (curr_background, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
        copy_timer (timer[0], temp_timer[0]);   // now restore timer
        copy_timer (timer[1], temp_timer[1]);

        if (result == 0 || result == -1)
            return 0;
        }

    return 0;
}

// display the tetris logo
void display_logo (BITMAP *dest)
{
    BITMAP *bitmap;
    BITMAP *bitmap1;
    BITMAP *trans;
    int x, y;

    bitmap = (BITMAP *)datafile[LOGO].dat;
    x = (SCREEN_W >> 1) - (bitmap->w >> 1);
    y = 15;

    trans = create_bitmap (bitmap->w+40, bitmap->h+20);
    bitmap1 = create_bitmap (bitmap->w, bitmap->h);
    if (trans == NULL || bitmap1 == NULL)
        exiting_error ("Not Enough Memory");

    clear (trans);
    set_trans_blender (0, 0, 0, 128);
    draw_trans_sprite (dest, trans, x-20, y-10);

    blit (bitmap, bitmap1, 0,0,0,0, bitmap->w, bitmap->h);
    draw_sprite (dest, bitmap1, x, y);
    //draw_sprite (dest, bitmap, x, y);


    destroy_bitmap (trans);
    destroy_bitmap (bitmap1);

    set_trans_blender (0, 0, 0, alpha_level);
}

// handles the event of the main menu. This his the first menu you should
// see when the program starts
void do_main_tetris_menu (void)
{
    MENU_DIM main_menu_dim;
    int result;

    load_sequential_background ();
    display_logo (curr_background);
    play_music_name ("letsdanc.s3m");

    while (1)
        {
        if (resume_game == TRUE)
            {
            sprintf (tetris_main_menu[5], "Resume Game");
            sprintf (tetris_main_menu[6], "%c", 0);
            }
        else
            sprintf (tetris_main_menu[5], "%c", 0);

        font = (FONT *) datafile[PLAYER_FONT].dat;
        draw_menu (curr_background, screen, &main_menu_dim, tetris_main_menu, 1, font, font);
        result = manage_menu (screen, &main_menu_dim);

        if (result == 0)
            select_player();
        else if (result == 1)
            do_options_menu();
        else if (result == 2)
            do_fame_menu();
        else if (result == 3 || result == -1)
            {
            if (do_exit_menu() == 1)
                return;
            }
        else if (result == 4)
            {
            resume_game = TRUE;
            play_tetris (-1, -1, -1);
            load_sequential_background ();
            display_logo (curr_background);
            play_music_name ("letsdanc.s3m");
            }
        }
}

void draw_sensitivity_menu (BITMAP *source, char **the_menu, MENU_DIM *mn)
{
    textout_centre(source, font, the_menu[1], SCREEN_W/2, mn->opt_y1 + (1 - mn->bar_thickness) * text_height(font), menu_for_color);
    textout_centre(source, font, the_menu[6], SCREEN_W/2, mn->opt_y1 + (6 - mn->bar_thickness) * text_height(font), menu_for_color);
}

void manage_sensitivity_menu (int *curr_opt, int old_opt)
{
    if (*curr_opt == 0)
        {
        if (old_opt == 1)
            *curr_opt = 8;
        else
            *curr_opt = 1;
        }
    else if (*curr_opt == 5)
        {
        if (old_opt == 6)
            *curr_opt = 3;
        }
    else if (*curr_opt == 4)
        {
        if (old_opt == 3)
            *curr_opt = 6;
        }
}

void do_sensitivity_menu (void)
{
    int result;
    int index;
    MENU_DIM sensitivity_menu_dim;

    while (1)
        {
        for (index=0; index < max_player; index++)
            {
            if (player[index].x_movement_speed < 1)
                player[index].x_movement_speed = 1;
            else if (player[index].x_movement_speed > 20)
                player[index].x_movement_speed = 20;

            if (player[index].y_movement_speed < 0)
                player[index].y_movement_speed = 0;
            else if (player[index].y_movement_speed > 20)
                player[index].y_movement_speed = 20;
                                    
            if (player[index].rotate_movement_speed < 1)
                player[index].rotate_movement_speed = 1;
            else if (player[index].rotate_movement_speed > 20)
                player[index].rotate_movement_speed = 20;
            }

        sprintf (sensitivity_menu[2], "X speed : %d", player[0].x_movement_speed);
        sprintf (sensitivity_menu[3], "Y speed : %d", player[0].y_movement_speed);
        sprintf (sensitivity_menu[4], "Rotate speed : %d", player[0].rotate_movement_speed);

        sprintf (sensitivity_menu[7], "X speed : %d", player[1].x_movement_speed);
        sprintf (sensitivity_menu[8], "Y speed : %d", player[1].y_movement_speed);
        sprintf (sensitivity_menu[9], "Rotate speed : %d", player[1].rotate_movement_speed);

        font = (FONT *) datafile[PLAYER_FONT].dat;
        draw_menu (curr_background, screen, &sensitivity_menu_dim, sensitivity_menu, 1, font, font, TRUE, draw_sensitivity_menu);
        result = manage_menu (screen, &sensitivity_menu_dim, manage_sensitivity_menu);

        if ( (result == 1) || (result == -201))
            player[0].x_movement_speed++;
        else if (result == -101) 
            player[0].x_movement_speed--;

        else if ( (result == 2) || (result == -202))
            player[0].y_movement_speed++;
        else if (result == -102)
            player[0].y_movement_speed--;

        else if ( (result == 3) || (result == -203))
            player[0].rotate_movement_speed++;
        else if (result == -103)
            player[0].rotate_movement_speed--;

        else if ( (result == 6) || (result == -206))
            player[1].x_movement_speed++;
        else if (result == -106)
            player[1].x_movement_speed--;

        else if ( (result == 7) || (result == -207))
            player[1].y_movement_speed++;
        else if (result == -107)
            player[1].y_movement_speed--;

        else if ( (result == 8) || (result == -208))
            player[1].rotate_movement_speed++;
        else if (result == -108)
            player[1].rotate_movement_speed--;

        else if (result == -1)
            return;
        }
}

void write_fame (int fame_no, char *name, int lines, int score)
{
    sprintf (fame_menu[fame_no+1], "%2d. %-21s     %3d     %5d", fame_no, name, lines, score);
}

void move_fame_down (int fame_no)
{
    int index;

    for (index=9; index >= fame_no-1; index--)
        {
        sprintf (fame_info[index].name, "%s", fame_info[index-1].name);
        fame_info[index].lines = fame_info[index-1].lines;
        fame_info[index].score = fame_info[index-1].score;
        }

    sprintf (fame_info[fame_no-1].name, "%c", 0);
    fame_info[fame_no-1].lines = 0;
    fame_info[fame_no-1].score = 0;
}

void do_fame_menu (void)
{
    int index;
    MENU_DIM fame_menu_dim;

    sprintf (fame_menu[0], "Hall of Fame");
    for (index=1; index <= 10; index++)
        write_fame (index, fame_info[index-1].name, fame_info[index-1].lines, fame_info[index-1].score);

    font = (FONT *) datafile[FIXED_WIDTH].dat;
    draw_menu (curr_background, screen, &fame_menu_dim, fame_menu, 1,
        (FONT *)datafile[PLAYER_FONT].dat, font, FALSE, NULL, makecol (255,255,255));

    //if (save_chart_cfg() == 1)
    //    exiting_error ("Error : Unable to save ");

    jg_readkey();
}

void manage_name_input (BITMAP *dest, int fame_no, MENU_DIM *mn)
{
    int x1, y1, width, height;
    int char_pointer, input;
    BITMAP *blue_bar;

    y1 = mn->y1+5;
    y1 += text_height (mn->title_font) * mn->bar_thickness;
    y1 += text_height (mn->normal_font)*fame_no;
    x1 = mn->x1+1;

    height = text_height (mn->normal_font);
    width  = text_length (mn->normal_font, fame_menu[1]) + 29;
    blue_bar = create_bitmap (width, height);

    char_pointer = strlen (fame_info[fame_no-1].name);
    sprintf (&fame_info[fame_no-1].name[char_pointer], "_");

    while (1)
        {
        write_fame (fame_no, fame_info[fame_no-1].name, fame_info[fame_no-1].lines, fame_info[fame_no-1].score);
        clear_to_color (blue_bar, menu_bar_color);
        textout_centre (blue_bar, mn->normal_font, fame_menu[fame_no+1], width/2-1, 0, menu_for_color);
        blit (blue_bar, screen, 0,0, x1, y1, width, height);
        
        input = jg_readkey();

        if ( (input >> 8) == KEY_ESC ||(input >> 8) == KEY_ENTER )
            break;
        else if ( (input >> 8) == KEY_BACKSPACE || (input >> 8) == KEY_LEFT )
            {
            char_pointer--;
            if (char_pointer < 0)
                char_pointer = 0;

            sprintf (&fame_info[fame_no-1].name[char_pointer], "_");
            }
        else if ( (input & 0xFF) >= 32 && (input & 0xFF) <= 126)
            {
            char_pointer++;
            if (char_pointer > 20)
                char_pointer = 20;
            else
                {
                fame_info[fame_no-1].name[char_pointer-1] = (input & 0xff);
                fame_info[fame_no-1].name[char_pointer] = '_';
                fame_info[fame_no-1].name[char_pointer+1] = 0;
                }
            }
        }

    fame_info[fame_no-1].name[char_pointer] = 0;
}


int get_player_fame (int score)
{
    int index;
    int fame = -1;

    for (index=9; index>=0; index--)
        if (score >= fame_info[index].score )
            fame = index + 1;

    return fame;
}
