#include "common.h"


// to detect lines completed in game_space. If detected, delete the line.
// returns the no of lines completed
int detect_line (int player_no)
{
    int x, y, line, line_completed=0;

    for (y=game_window_height-1; y >= 0; y--)
        {
        line = TRUE;
        for (x=0; x < game_window_width; x++)
            {
            if (player[player_no].game_space[x][y] < 0)  
                line = FALSE;
            }

        // line detected. Delete
        if (line == TRUE)
            {
            move_line (player_no, y);
            line_completed++;
            y = game_window_height;
            }
        }

    return (line_completed);
}

// delete line line_no in game_space arrary and shift downwards
void move_line (int player_no, int line_no)
{
    int x, y;

    // shift lines downwards
    for (y=line_no; y > 0; y--)
        for (x=0; x < game_window_width; x++)
            player[player_no].game_space[x][y] = player[player_no].game_space[x][y-1];

    // clear the uppest row
    for (x=0; x < game_window_width; x++)
        player[player_no].game_space[x][0] = -1;

}

// set backup game space to -1
void clear_old_game_space (int player_no, int clear)
{
    int x, y;

    for (x=0; x<game_window_width; x++)
        for (y=0; y<game_window_height; y++)
           player[player_no].old_game_space[x][y] = clear;
}

// draw the windows which contains player score, infos ....
void draw_info_window (BITMAP *bitmap, int player_no)
{
    int center = 57;
    char temp[30];
    
    blit (player[player_no].game_info_buffer, temp_buffer, 0,0,0,0,
            block_width * game_info_width, block_height * game_info_height);

    // now print strings to the info window
    font = (FONT *)datafile[PLAYER_FONT].dat;
    sprintf (temp, "Player %d", player_no+1);
    textout_centre(temp_buffer, font, temp, center, 5, makecol (255,255,255));

    font = (FONT *)datafile[SMALL_FONT].dat;
    sprintf (temp, "Lines done = %d", player[player_no].lines_done);
    textout_centre(temp_buffer, font, temp, center, 120, makecol (255,255,255));

    sprintf (temp, "Lines left = %d", player[player_no].lines_left);
    textout_centre(temp_buffer, font, temp, center, 136, makecol (255,255,255));

    sprintf (temp, "Score = %d", player[player_no].score);
    textout_centre(temp_buffer, font, temp, center, 152, makecol (255,255,255));

    sprintf (temp, "Level = %d", player[player_no].level);
    textout_centre(temp_buffer, font, temp, center, 168, makecol (255,255,255));


    draw_info_block (temp_buffer, player[player_no].next_block, 28, 38);

    blit (temp_buffer, bitmap, 0,0, player[player_no].game_info_xpos,
            player[player_no].game_info_ypos, block_width * game_info_width,
            block_height * game_info_height);
}

// draw a block in to game_space array
void draw_block (int player_no, int x, int y, int block_no, int rotation)
{
    int temp, dx, dy;
    int bit_test;

    for (temp=0; temp < 16; temp ++)
        {
        dx = temp % 4;
        dy = temp / 4;
        bit_test = (1 << temp);

        // make sure doesn't access out of array
        if ( (x+dx < 0) || (x+dx >= game_window_width) )
            continue;

        if ( (y+dy < 0) || (y+dy >= game_window_height) )
            continue;

        if (block[block_no].pos[rotation] & bit_test)
            player[player_no].game_space[x+dx][y+dy] = block[block_no].bitmap;
        }
}

//draws next block into the info window 
void draw_info_block (BITMAP *bitmap, int block_type, int x, int y)
{
    int temp_x, temp_y, temp, bit_test;
    BITMAP *block_bitmap;

    block_bitmap = (BITMAP *) datafile[block[block_type].bitmap ].dat;

    for (temp=0; temp < 16; temp++)
        {
        temp_x = x + block_width * (temp % 4);
        temp_y = y + block_height * (temp / 4);
        bit_test = (1 << temp);

        // center align for certain block
        if (block_type == 0 || block_type == 2)
            temp_x -= (block_width/2);

        if  (block_type == 0)
            temp_y -= (block_height/2);

        if (block[block_type].pos[0] & bit_test)
            blit (block_bitmap, bitmap, 0,0, temp_x, temp_y, block_width, block_height);
        }
}

// arrays of blocks to the game window. Update only when necessary
// to know what is necessary, game_space and old_game_space is used.
void display_game_block (BITMAP *dest, int player_no)
{
    int x, y;
    BITMAP *block_bitmap;

    for (x=0; x<game_window_width; x++)
        for (y=0; y<game_window_height; y++)
            {
            // detect changes
            if (player[player_no].game_space[x][y] != player[player_no].old_game_space[x][y])
                {
                if (player[player_no].game_space[x][y] >= 0)
                    {
                    block_bitmap = (BITMAP *) datafile[ player[player_no].game_space[x][y] ].dat;
                    blit (block_bitmap, dest, 0,0, player[player_no].game_window_xpos + (x*block_width),
                        player[player_no].game_window_ypos + (y*block_height), block_width, block_height);
                    }
                else if  (player[player_no].game_space[x][y] < 0)
                    blit (player[player_no].game_window_buffer, dest, x*block_width, y*block_height, player[player_no].game_window_xpos + (x*block_width), player[player_no].game_window_ypos + (y*block_height), block_width, block_height);
                }
            }
}

// set game space to -1
void clear_game_space (int player_no)
{
    int x, y;

    for (x=0; x<game_window_width; x++)
        for (y=0; y<game_window_height; y++)
           player[player_no].game_space[x][y] = -1;
}


// backup the game space to old game space
void backup_game_space (int player_no)
{
    int x, y;

    for (x=0; x<game_window_width; x++)
        for (y=0; y<game_window_height; y++)
            player[player_no].old_game_space[x][y] = player[player_no].game_space[x][y];
}

// to erase a block in the array
void erase_block (int player_no, int x, int y, int block_no, int rotation)
{
    int temp, dx, dy;
    int bit_test;

    for (temp=0; temp < 16; temp ++)
        {
        dx = temp % 4;
        dy = temp / 4;
        bit_test = (1 << temp);

        // make sure doesn't draw out of the array
        if ( (x+dx < 0) || (x+dx >= game_window_width) )
            continue;

        if ( (y+dy < 0) || (y+dy >= game_window_height) )
            continue;

        if (block[block_no].pos[rotation] & bit_test)
            player[player_no].game_space[x+dx][y+dy] = -1;
        }
}

//returns TRUE if a block is detected in the array. Else false.
int detect_block (int player_no, int x, int y, int block_no, int rotation)
{
    int temp, dx, dy;
    int bit_test;

    for (temp=0; temp < 16; temp ++)
        {
        dx = temp % 4;
        dy = temp / 4;
        bit_test = (1 << temp);

        if (block[block_no].pos[rotation] & bit_test)
            {
            if ( (x+dx < 0) || (x+dx >= game_window_width) )
                return TRUE;    // out of array

            if ( (y+dy) >= game_window_height )
                return TRUE;    // out of array

            if ( (y+dy) < 0)
                continue;       // ignore and continue at next block

            if (player[player_no].game_space[x+dx][y+dy] >= 0)
                return TRUE;
            }
        }

    return FALSE;
}
