/*  I did this starfield 2 years ago. With the scrolling text added, it just
    looks cool. 
*/

#include <stdlib.h>
#include "common.h"
#include "credits.h"


int need_to_blit = FALSE;
int ypos, no_lines, string_height;

// draws fading line from (x1, y1) to (x2, y2)
// Uses fixed point numbers to draws line accurately.
void draw_fading_line (BITMAP *dest, int x1, int y1, int x2, int y2, int color)
{
    int x, y, counter; 
    fixed dx, dy, curr_x, curr_y, fade_color, dc;

    //I know. Why multiple ifs when I can have it all in one if? Speed
    //reason.Multiple ifs like below are much faster than single if. Suprise!
    if (x1<0 && x1>(SCREEN_W-1))
        if (y1<0 && y1>(SCREEN_H-1))
            if (x2<0 && x2>(SCREEN_W-1))
                if (y2<0 && y2>(SCREEN_H-1))
                    return;

    x = ABS (x1 - x2);
    y = ABS (y1 - y2);
    fade_color = itofix(color);
        
    if (x > y) // slope < -1 or  > 1
        {
        curr_y = itofix(y1);
        dx = itofix((x1 > x2) ? -1 : 1);
        dc = itofix(color) / x;

        if (x1 == x2)
            dy = itofix(0);
        else 
            dy = ftofix((float)(y1-y2) / (x1-x2));

        dy = fmul (dy, dx);
        counter = x1;
        while (counter != x2)
            {
            if (counter >= 0)
                if (counter < 639)
                    if (curr_y >= 0)
                        if (curr_y < 31391744)
                            _putpixel (dest, counter, fixtoi(curr_y), fixtoi(fade_color));

            fade_color -= dc;            
            curr_y+= dy;
            counter += fixtoi(dx);
            
            if (fade_color < 0)
                color = 0;
            }
        } 
    else        //  -1 <= slope <= 1
        {
        curr_x = itofix(x1);
        dy = itofix((y1 > y2) ? -1 : 1);

        if (y1 == y2)
            dx = itofix(0);
        else
            dx = ftofix(((float)(x1-x2) / (y1-y2)));

        dx = fmul (dx, dy);
        dc = itofix (color)/y;
        counter = y1;

        while (counter != y2)
            {
            if (counter >= 0)
                if (counter < 480)
                    if (curr_x >= 0)
                        if (curr_x < 41877504)
                            _putpixel (dest, fixtoi(curr_x), counter, fixtoi(fade_color));

            fade_color -= dc;
            counter += fixtoi(dy);
            curr_x += dx;
            if (fade_color < 0)
                fade_color = 0;
            }
        }
}

// accelerate all stars
void accelerate_stars (void)
{
    int starno, counter;

    for (starno=0; starno < no_of_stars; starno++)
        {
        if ( (stars[starno].x[0] > 400) && (stars[starno].x[1] > 400) )
            {
            stars[starno].x[0]           = random() % 325;
            stars[starno].angle         = random() % 360;
            stars[starno].x_velocity     = ((random() % 999) / 1000) + 1;
            stars[starno].current_color  = (uchar)((stars[starno].x_velocity * color_inc) + stars[starno].original_color);
            stars[starno].x[1]           = stars[starno].x[0] - stars[starno].x_velocity;
            }

        stars[starno].x[0] += stars[starno].x_velocity;
        stars[starno].x[1] = stars[starno].x[0] - tail_length * stars[starno].x_velocity;
        stars[starno].x_velocity += (stars[starno].x_velocity / speed_reduce);
        stars[starno].current_color  = (uchar)((stars[starno].x_velocity * color_inc) + stars[starno].original_color);
        if (stars[starno].current_color > 63)
            stars[starno].current_color = 63;

        for (counter=0; counter<2; counter++)
            {
            stars[starno].new_x[counter] = (stars[starno].x[counter] * cos_table[stars[starno].angle]) + 320;
            stars[starno].new_y[counter] = (stars[starno].x[counter] * sin_table[stars[starno].angle]) + 240;
            }

        }
}

// the main loop of the star field
void vstrfld(void)
{
    RGB color_register;
    int result;
    int counter;
    int starno;

    // play starwars music
    enable_lasttrk_loop = FALSE;

    set_mod_volume (music_volume);
    play_music_name("starwars.mod", FALSE);

    //stop_mod();
    //destroy_mod (curr_mod);
    //curr_mod = load_mod ("starwars.mod");
    //if (curr_mod == NULL)
    //    return;

    set_color_depth (8);    // I want 256 colors
    result = set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0); // change to 256 colours now
    if (result < 0)
        return;

    destroy_bitmap (curr_background);           // delete 16bit bitmap
    destroy_bitmap (temp_buffer);
    curr_background = create_bitmap (SCREEN_W, SCREEN_H); // make a 8bit bitmap
    temp_buffer = create_sub_bitmap (curr_background, 0, 100, SCREEN_W, 280);
    if ( curr_background==NULL )    // skip if insufficient memory
        return;         

    clear (curr_background);

    // set pallete from gradient of black to white
    for (counter=0; counter < 64; counter++)
        {
        color_register.r = counter;
        color_register.g = counter;
        color_register.b = counter;
        
        set_color (counter, &color_register);
        }

    font = (FONT *)datafile[PLAYER_FONT].dat;
    string_height = text_height (font);
    for (counter=0; credits[counter][0];counter++)  // count no of lines in credits array
        no_lines++;

    
    //play_mod (curr_mod, FALSE);

    timer[0].left = 0;
    timer[0].right = 0;
    while (!key[KEY_ESC] && !key[KEY_SPACE] && !key[KEY_ENTER])
        {
        if (is_music_playing() == FALSE)
            play_random_music();

        while (timer[0].left >= 3)
            {
            accelerate_stars(); 
            timer[0].left -= 3;     // stars position has been updated
            need_to_blit = TRUE;    // should update the screen too
            }

        if (need_to_blit == TRUE)   // now update the screen
            {
            clear (curr_background);
            for (starno=0; starno < no_of_stars; starno++)
                draw_fading_line (curr_background, (int)stars[starno].new_x[0], (int)stars[starno].new_y[0], (int)stars[starno].new_x[1], (int)stars[starno].new_y[1], stars[starno].current_color);


            if (key[KEY_DOWN])
                {
                timer[0].right -= 15;
                if (timer[0].right < 0)
                    timer[0].right = 0;
                }

            if (key[KEY_UP])
                timer[0].right += 20;

            if (key[KEY_R])
                timer[0].right = 0;

            // calculate the position of the scrolling text
            ypos = 285 - (timer[0].right / 3);
            
            if (ypos < ( 220-(string_height/2) - (string_height*(no_lines+2))+5) )
                ypos = ( 220-(string_height/2) - (string_height*(no_lines+2))+5);

            for (starno=0; starno < no_lines ;starno++)
                {
                result = font_fading(temp_buffer, ypos + (string_height * starno));
                textout_centre(temp_buffer, font, credits[starno], 320, ypos + (string_height * starno), result);
                }

            blit (curr_background, screen, 0,0,0,0, 640, 480);
            need_to_blit = FALSE;
            }
        }
}

// calculate the intensity of the scrolling text according their y coordinates
int font_fading(BITMAP *dest, int ypos)
{
    if (ypos <= 100)
        return ((ypos * 53) / 100) + 10;
    else if (ypos >= (dest->h - 120) &&  ypos < (dest->h - 20) )
        return (ABS(ypos - dest->h+20) * 63 / 100) + 0;
    else if (ypos >= (dest->h - 20))
        return 0;

    return 63;
}
