#include <libamp.h>
#include <jpeg.h>
#include <libamp.h>
#include "common.h"


//when proper exit, you will see this message
void exiting_message (void)
{
    set_gfx_mode (GFX_TEXT, 0,0,0,0);

    printf ("JTRIS v%s\n", tetris_version);
    printf ("Written by Guan Foo Wah\n");
    printf ("Released : 31 August 2000\n\n");

    printf ("This program is a freeware. You are free to distribute this program to\n");
    printf ("anyone, anywhere in any disk format (eg. diskette, CD-ROM ...). This\n");
    printf ("program cannot be modified or altered without permission from the author.\n\n");

    printf ("If there is any bugs or errors, please do not hesitate to report it to\n");
    printf ("me. My e-mail address is jgfw@iname.com\n\n");

    printf ("Go to http://surf.to/jgmod for the latest version\n");
}

// loads sequential background from pictures.dat into curr_background buffer
void load_sequential_background(void)
{
    char name[30];

    if (curr_background_no == -1)
        curr_background_no = random() % no_background;
    else
        {
        curr_background_no++;
        if (curr_background_no >= no_background)
            curr_background_no = 0;
        }

    sprintf (name, "pictures.dat#BACKGROUND_%03d", curr_background_no);

    if (curr_background != NULL)
        destroy_bitmap (curr_background);

    curr_background = load_jpeg (name, NULL);

    if (curr_background == NULL)
        {
        set_gfx_mode (GFX_TEXT, 0,0,0,0);
        printf ("Error : Unable to load background pictures\n");
        exit (1);
        }

}

// loads same background from pictures.dat into curr_background buffer
void load_same_background(void)
{
    char name[30];

    if (curr_background_no == -1)
        curr_background_no = random() % no_background;

    sprintf (name, "pictures.dat#BACKGROUND_%03d", curr_background_no);

    if (curr_background != NULL)
        destroy_bitmap (curr_background);

    curr_background = load_jpeg (name, NULL);

    if (curr_background == NULL)
        {
        set_gfx_mode (GFX_TEXT, 0,0,0,0);
        printf ("Error : Unable to load background pictures\n");
        exit (1);
        }
}


// draw a rectangular box from (x1, y2) to (x2, y2) in color to specified
// bitmap
void draw_box (BITMAP *bitmap, int x1, int y1, int x2, int y2, int color)
{
    vline (bitmap, x1, y1, y2, color);
    vline (bitmap, x2, y1, y2, color);
    hline (bitmap, x1, y1, x2, color);
    hline (bitmap, x1, y2, x2, color);
}

// if the player press F9 keys. Then call detect_some_f_keys do detect
// the rest of F keys
void detect_F_keys (int no_player)
{
    int ch;

    if (keypressed())   // if kbhit()
        {
        ch = jg_readkey();     // getch()

        detect_some_F_keys (no_player, ch, FALSE);

        if ( ((ch >> 8) == KEY_F9) && key[KEY_F9] )    // pause game
            pause_game (no_player);
        }
}

// common detection of Fx keys are all here
void detect_some_F_keys (int no_player, int ch, int pause)
{
    volatile TIMER timer_temp[max_player];

    if ( ((ch >> 8) == KEY_F1) && key[KEY_F1] )         // reduce sfx volume
        {
        sfx_volume -= 17;
        if (sfx_volume < 0)
            sfx_volume = 0;
        else
            play_sample ((SAMPLE *)datafile[ROTATE].dat, sfx_volume, 128, 1000, FALSE);
        }

    else if ( ((ch >> 8) == KEY_F2) && key[KEY_F2] )    // increase sfx volume
        {
        sfx_volume += 17;
        if (sfx_volume > 255)
            sfx_volume = 255;
        else
            play_sample ((SAMPLE *)datafile[ROTATE].dat, sfx_volume, 128, 1000, FALSE);
        }

    else if ( ((ch >> 8) == KEY_F3) && key[KEY_F3] )    // reduce music volume
        {
        music_volume -= 17;
        if (music_volume < 0)
            music_volume = 0;
        set_mod_volume (music_volume);
        }
    else if ( ((ch >> 8) == KEY_F4) && key[KEY_F4] )    // increase music volume
        {
        music_volume += 17;
        if (music_volume > 255)
            music_volume = 255;
        set_mod_volume (music_volume);
        }
    else if ( ((ch >> 8) == KEY_F5) && key[KEY_F5] )    // fast reverse music
        fr_music();
    else if ( ((ch >> 8) == KEY_F6) && key[KEY_F6] )    // fast forward music
        ff_music();
    else if ( ((ch >> 8) == KEY_F7) && key[KEY_F7] )    // prev music
        {
        copy_timer (timer_temp[0], timer[0]); // backup timer
        copy_timer (timer_temp[1], timer[1]); 
        play_prev_music();
        copy_timer (timer[0], timer_temp[0]); // restore timer
        copy_timer (timer[1], timer_temp[1]); 
        }

    else if ( ((ch >> 8) == KEY_F8) && key[KEY_F8] )    // next music
        {
        copy_timer (timer_temp[0], timer[0]); // backup timer
        copy_timer (timer_temp[1], timer[1]); 
        play_next_music();
        copy_timer (timer[0], timer_temp[0]); // restore timer
        copy_timer (timer[1], timer_temp[1]); 
        }

    else if ( ((ch >> 8) == KEY_F10) && key[KEY_F10] )  // change new background
        {
        MENU_DIM pause_menu_dim;
        int player_no;

        copy_timer (timer_temp[0], timer[0]); // backup timer
        copy_timer (timer_temp[1], timer[1]); 
        clear_old_game_space (0, -2);
        clear_old_game_space (1, -2);
        ready_game_background (no_player, pause);

        if (pause == TRUE)
            {
            font = (FONT *)datafile[PLAYER_FONT].dat;
            draw_menu (curr_background, screen, &pause_menu_dim, pause_menu, 1, font, font);
            }
        else
            blit (curr_background, screen, 0,0,0,0, SCREEN_W, SCREEN_H);

        copy_timer (timer[0], timer_temp[0]); // restore timer
        copy_timer (timer[1], timer_temp[1]); 
        }

    else if ( ((ch >> 8) == KEY_F11) && key[KEY_F11] )  // random music
        {
        copy_timer (timer_temp[0], timer[0]); // backup timer
        copy_timer (timer_temp[1], timer[1]); 
        play_random_music();
        copy_timer (timer[0], timer_temp[0]); // restore timer
        copy_timer (timer[1], timer_temp[1]); 
        }

    else if ( ((ch >> 8) == KEY_F12) && key[KEY_F12] )    // screen shot
        {
        BITMAP *screen_shot;

        copy_timer (timer_temp[0], timer[0]); // backup timer
        copy_timer (timer_temp[1], timer[1]); 
        screen_shot = create_sub_bitmap (screen, 0, 0, 640, 480);
        save_bmp ("scrnshot.bmp", screen_shot, NULL);
        copy_timer (timer[0], timer_temp[0]); // restore timer
        copy_timer (timer[1], timer_temp[1]); 
        }
}

// ready the background first before entering the actual game
void ready_game_background (int no_player, int pause, int same)
{
    int x2, y2, line_color;
    int player_no;

    line_color = makecol (255, 255, 255);   //RGB (255, 255, 255) = white 

    if (same == FALSE)
        load_sequential_background ();
    else
        {
        curr_background_no = resume_curr_background;
        load_same_background();
        }

    for (player_no=0; player_no < no_player; player_no++)
        {
        // calculate position of lower right edge 
        y2 = player[player_no].game_window_ypos + (block_height * game_window_height);
        x2 = player[player_no].game_window_xpos + (block_width * game_window_width);
        draw_box (curr_background, player[player_no].game_window_xpos-1, player[player_no].game_window_ypos-1, x2, y2, line_color);

        blit (curr_background, temp_buffer,
            player[player_no].game_window_xpos,
            player[player_no].game_window_ypos, 0, 0,
            block_width * game_window_width,
            block_height * game_window_height);

        // draw semi-transparent background for game window
        clear (player[player_no].game_window_buffer);
        draw_trans_sprite (player[player_no].game_window_buffer, temp_buffer, 0,0);
        blit (player[player_no].game_window_buffer, curr_background, 0,0,
            player[player_no].game_window_xpos, player[player_no].game_window_ypos, 
            block_width * game_window_width, block_width * game_window_height);

        y2 = player[player_no].game_info_ypos + (block_height * game_info_height);
        x2 = player[player_no].game_info_xpos + (block_width * game_info_width);
        draw_box (curr_background, player[player_no].game_info_xpos-1, player[player_no].game_info_ypos-1, x2, y2, line_color);

        blit (curr_background, temp_buffer,
            player[player_no].game_info_xpos,
            player[player_no].game_info_ypos, 0, 0,
            block_width * game_info_width,
            block_height * game_info_height);

        //draw semi-transparent background for info window
        clear (player[player_no].game_info_buffer);
        draw_trans_sprite (player[player_no].game_info_buffer, temp_buffer, 0,0);
        draw_info_window (curr_background, player_no);


        if (pause == TRUE && player[player_no].status == active)
            {
            blit (screen, curr_background, player[player_no].game_window_xpos,
                player[player_no].game_window_ypos, player[player_no].game_window_xpos,
                player[player_no].game_window_ypos, block_width * game_window_width,
                block_width * game_window_height);
            }
        else
            {
            draw_block (player_no, player[player_no].block_x, player[player_no].block_y, player[player_no].curr_block, player[player_no].rotation);
            display_game_block(curr_background, player_no);
            }
        }
}

// it to pause the game
void pause_game (int no_player)
{
    volatile TIMER temp_timer[max_player];
    int x,y, player_no, random_block;
    int x_pos, y_pos;
    MENU_DIM pause_menu_dim;

    copy_timer (temp_timer[0], timer[0]);   // backup timer first
    copy_timer (temp_timer[1], timer[1]);

    clear_old_game_space (0, -2);
    clear_old_game_space (1, -2);
    for (player_no=0; player_no < no_player; player_no++)
        {
        if (player[player_no].status != active)
            continue;

        for (x=0; x<game_window_width; x++)
            for (y=0; y<game_window_height; y++)
                {
                random_block = random () % max_block;
                x_pos = player[player_no].game_window_xpos + (x * block_width);
                y_pos = player[player_no].game_window_ypos + (y * block_height);

                blit ((BITMAP *)datafile[block[random_block].bitmap].dat, screen, 0,0,x_pos,y_pos, block_width, block_height);
                }
        }

    blit (screen, curr_background, 0,0,0,0, SCREEN_W, SCREEN_H);
    font = (FONT *)datafile[PLAYER_FONT].dat;
    draw_menu (curr_background, screen, &pause_menu_dim, pause_menu, 1, font, font);

    while (key[KEY_F9])     // wait until key is released
        {}

    while (!key[KEY_F9])    // wait until key is pressed
        {
        if (is_music_playing() == FALSE)
            play_random_music();

        if (keypressed())   // if kbhit()
            {
            int ch;

            ch = jg_readkey();     // getch()

            detect_some_F_keys (no_player, ch, TRUE);
            }
        }

    while (key[KEY_F9])     // wait until key is released
        {}

    blit (curr_background, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
    copy_timer (timer[0], temp_timer[0]);   // now restore timer
    copy_timer (timer[1], temp_timer[1]);
}

// backup timer b in to timer a
void copy_timer (volatile TIMER &a, volatile TIMER &b)
{
    a.left      = b.left;
    a.right     = b.right;
    a.down      = b.down;
    a.cw        = b.cw;
    a.ccw       = b.ccw;
    a.move_down = b.move_down;
}

// print an error message and then exit
void exiting_error (char *message)
{
    set_gfx_mode (GFX_TEXT, 0,0,0,0);
    printf ("%s", message);
    exit (1);
}

// save configurations in to config.cfg
void save_config_cfg (void)
{
    FILE *file;
    int index;

    file = fopen ("config.cfg", "wb");
    if (file == NULL)
        exiting_error ("Error : Unable to open config.cfg\n");

    // save 1 player mode keys
    for (index=0; index<5; index++)
        fputc (player_keys[0].p[index], file);

    // save 2 player mode keys
    for (index=0; index<10; index++)
        fputc (player_keys[1].p[index], file);

    fputc (change_background, file);    // save change background
    fputc (music_sequential, file);     // save music order type
    fputc (alpha_level, file);          // save alpha level
    fputc (no_channels, file);          // save no of voices/channels
    fputc (sfx_volume, file);           // save sfx volume
    fputc (music_volume, file);         // save music volume

    for (index=0; index<max_player; index++)
        {
        fputc (player[index].x_movement_speed ,file);
        fputc (player[index].y_movement_speed ,file);
        fputc (player[index].rotate_movement_speed ,file);
        }

    fclose (file);
}

// save top chart to file
int save_chart_cfg (void)
{
    FILE *f;
    int index;
    char name[255];

    f = jfopen ("chart.cfg", "wb");
    if (f == NULL)
        return 1;
        

    // put in the IDs
    jfputc (23,  f);
    jfputc (34,  f);
    jfputc (255, f);
    jfputc (2,   f);

    for (index=0; index<10; index++)
        {
        jiputl (fame_info[index].lines,f);
        jiputl (fame_info[index].score,f);
        jfwrite (fame_info[index].name, f);

        // a backup. To save from chart.cfg being tempered.
        jiputl (fame_info[index].lines,f);
        jiputl (fame_info[index].score,f);
        jfwrite (fame_info[index].name, f);
        }

    jfclose (f);
    return 0;
}


int jg_readkey(void)
{
    while (!keypressed())
        {
        if (is_music_playing() == FALSE)
            play_random_music();

        run_amp();
        }

    return readkey();
}

