//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "Itana.h"
#include "Parser.h"

//binary output function -- Intel format

int Parser::makePoint(char* buf, int startPos, const Point& value) {
  startPos = makeDouble(buf, startPos, value.x);
  startPos = makeDouble(buf, startPos, value.y);
  return (startPos);
}

int Parser::makeVect(char* buf, int startPos, const Vector& value) {
  startPos = makeDouble(buf, startPos, value.getMag());
  startPos = makeDouble(buf, startPos, value.getTheta());
  return (startPos);
}

int Parser::makeDouble(char* buf, int startPos, double value) {
  //saves doubles as floats
  float temp = value;
  startPos = makeDirect(buf, startPos, temp);
  return (startPos);
}

int Parser::makeString(char* buf, int startPos, const char* value) {
  strcpy(&buf[startPos], value);
  return (startPos + strlen(value) + 1);
}

//binary input functions -- Intel format

int Parser::parsePoint(const char* buf, int startPos, Point& value) {
  startPos = parseDouble(buf, startPos, value.x);
  startPos = parseDouble(buf, startPos, value.y);
  return (startPos);
}

int Parser::parseVect(const char* buf, int startPos, Vector& value) {
  double mag, theta;
  startPos = parseDouble(buf, startPos, mag);
  startPos = parseDouble(buf, startPos, theta);
  value.initPolar(theta, mag);
  return (startPos);
}

int Parser::parseDouble(const char* buf, int startPos, double& value) {
  //saves doubles as floats
  float temp;
  startPos = parseDirect(buf, startPos, temp);
  value = temp;
  return (startPos);
}

int Parser::parseString(const char* buf, int startPos, char* value) {
  strcpy(value, &buf[startPos]);
  return (startPos + strlen(&buf[startPos]) + 1);
}