//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "ParaBullet.h"
#include "Video.h"
#include "itanadat.h"
#include "EntityConsts.h"

const IntRect PARALIZE_RECT(0, 0, 32, 32);
const IntRect PARABOLT_RECT(0, 0, 32, 32);
DATAFILE* ParaBullet::paralize = NULL;
DATAFILE* ParaBullet::parabolt = NULL;

ParaBullet::ParaBullet(const Point& p, const Vector& rel, double theta)
: Bullet(p, rel, theta, ID_PARA) {
}

ParaBullet::ParaBullet() : Bullet( ID_PARA ) {
}

void ParaBullet::initVideo(DATAFILE* root) {
  paralize = (DATAFILE*)(root[PARALIZE].dat);
  parabolt = (DATAFILE*)(root[PARABOLT].dat);
}

void ParaBullet::init(const Point& p, const Vector& rel, double theta) {
  Bullet::init(p, rel, theta, ID_PARA);
}

void ParaBullet::draw() {
  Video::drawSprite((BITMAP*)parabolt[getrnd(PARABOLT_COUNT-1, 0)].dat,
    IntRect(loc.x, loc.y, PARABOLT_RECT.w, PARABOLT_RECT.h), scrLoc, radToFix(theta));
}

void ParaBullet::draw(const Point& center) {
  Video::setAddBlender();
  Video::drawTransSprite((BITMAP*)paralize[getrnd(PARALIZE_COUNT-1, 0)].dat,
    IntRect(center.x - PARALIZE_RECT.w/2, center.y - PARALIZE_RECT.h/2, PARALIZE_RECT.w, PARALIZE_RECT.h));
  Video::setDefaultBlender();
}