//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _PACKETCONSTS_H_
#define _PACKETCONSTS_H_

typedef unsigned char uchar;
typedef unsigned short ushort;
typedef uchar PacketType;
typedef uchar PlayerId;
typedef ushort Actions;

const uchar NONE           = 0;
const uchar SHIP           = 1;
const uchar DYNAMICENTITY  = 2;
const uchar PLAYER         = 3;
const uchar PLAYERPART     = 4;
const uchar PLAYERMESSAGE  = 5;
const uchar ORBITINGENTITY = 6;
const uchar DAMAGE         = 7;
const uchar FRAME          = 8;
const uchar DEATH          = 9;
const uchar RESPAWN        = 10;
const uchar STATSPACKET    = 11;
const uchar PING           = 12;
const uchar GREET          = 13;
const uchar SERVERQUIT     = 14;
const uchar ENDOFPACKET    = 255;

//Shot type constants for DamagePacket go here

const uchar NORMALDAMAGE = 0;
const uchar PARADAMAGE   = 1;

//Death type constants
const uchar PLANETDEATH = 0;
const uchar BANGEDDEATH = 1;
const uchar SHOTDEATH   = 2;

//Packet creation consts

const uchar PROTOCOLVERSION = 3; //For the GreetingPacket
const int   PACKETMAX = 300;     //continue to add packets until size is greater than PACKETMAX

const int ACCELERATE = 1;
const int AFTERBURN  = 2;
const int TURNLEFT   = 4;
const int TURNRIGHT  = 8;
const int SLOWTURN   = 16;
const int DOCKING    = 32;
const int FIREUP     = 64;
const int FIREDOWN   = 128;
const int FIRELEFT   = 256;
const int FIRERIGHT  = 512;
const int FIRESPECIAL= 1024;
const int PARALIZED  = 2048;
const int CLOAKED    = 4096;

#endif