//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "itanadat.h"
#include "OrnonShip.h"
#include "Vector.h"
#include "Video.h"
#include "OrnonBullet.h"
#include "PlasmaBullet.h"
#include "Game.h"
#include "ShipStats.h"
#include "Sound.h"
#include "MovingEffect.h"

//Ornon engines
const int NUM_ENGINES = 3;
const Vector engines[NUM_ENGINES] = {Vector(-24,0), Vector(-24, -24), Vector(-24, 24)};

const double BLASTER_RECOIL = 0.1;
const double PLASMA_RECOIL  = 1;

OrnonShip::OrnonShip() {
  type = ORNON_STATS;
  id = ID_ORNON_SHIP;
  currEngine = 0;
  leftReload = rightReload = downReload = 0;
}

void OrnonShip::init(const Rect& rect, const Vector& vect) {
  Ship::init(rect, vect);
}

void OrnonShip::input() {
  Ship::input();
}

bool OrnonShip::update() {
  if (leftReload)
    leftReload--;
  if (rightReload)
    rightReload--;
  if (downReload)
    downReload--;
  return Ship::update();
}

void OrnonShip::draw() {
  if (!dead) {
    Video::drawSprite(GRFX_DAT_ORNSHIP_BMP, loc, scrLoc, radToFix(theta));
    Ship::draw();
  }
}

void OrnonShip::fire(int dir) {
  //Ornon ships fire a directional blaster
  if (energy >= STATS[type].fireuse) {
    //Determine direction and firing capability
    double direction = 0.0;//which direction to fire in
    bool firing = false;   //are we able to fire
    Actions actionFlag;    //action flag to add when firing occurs
    
    switch (dir) {
    case UP:
      if (normalReload == 0) {
        firing = true;
        normalReload = STATS[type].firedelay;
        direction = theta;
      }
      actionFlag = FIREUP;
      break;
    case DOWN:
      if (downReload == 0) {
        firing = true;
        downReload = STATS[type].firedelay;
        direction = theta + PI;
      }
      actionFlag = FIREDOWN;
      break;
    case LEFT:
      if (leftReload == 0) {
        firing = true;
        leftReload = STATS[type].firedelay;
        direction = theta - PI / 2.0;
      }
      actionFlag = FIRELEFT;
      break;
    default: //case RIGHT
      if (rightReload == 0) {
        firing = true;
        rightReload = STATS[type].firedelay;
        direction = theta + PI / 2.0;
      }
      actionFlag = FIRERIGHT;
      break;
    }
    
    //Fire the bullet and handle other
    if (firing) {
      Ship::fire(new OrnonBullet(loc.getCenter(), vect, direction), direction + PI, BLASTER_RECOIL);
      Sound::playMapSound(SFX_DAT_LASER_WAV, loc.getCenter());
      energy -= STATS[type].fireuse;
    }
    actions |= actionFlag;
  }
}

void OrnonShip::special() {
  //Ornon ships fire a plasmabolt
  if (control == CTRL_LOCAL && energy >= STATS[type].specialuse) {
    //Plasma bolts are sent explicitly over the network.
    if (specialReload == 0) {
      Sound::playMapSound(SFX_DAT_PARA_WAV, loc.getCenter());
      Ship::fire(new PlasmaBullet(loc.getCenter(), vect, theta), theta + PI, PLASMA_RECOIL);
      energy -= STATS[type].specialuse;
      specialReload = STATS[type].specialdelay;
    }
    actions |= FIRESPECIAL;
  }
}

void OrnonShip::throwEngineParticle(const Vector& partVect) {
  if ((Game::getFrame() % 4) == 0) {
    Vector temp = engines[currEngine];
    currEngine++;
    if (currEngine >= NUM_ENGINES)
      currEngine = 0;

    temp.rotate(theta);
    double midx = loc.x + loc.w/2;
    double midy = loc.y + loc.h/2;
    FadeParticle* newParticle = new FadeParticle(Point(midx + temp.getMagx(), midy + temp.getMagy()),
                                                 200, partVect, 128, 255, 64);
    Game::moveEffect(newParticle);
  }
}