//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "Itana.h"
#include "MovingEffect.h"
#include "Video.h"
#include "Sound.h"
#include "IntRect.h"
#include "itanadat.h"
#include "Prefs.h"
#include "Game.h"

//*** MovingEffect ***//

bool MovingEffect::update() {
  vect.addTo(loc);
  return Effect::update();
}

FadeParticle::FadeParticle(const Point& loc2, int life2, const Vector& vect2, int r2, int g2, int b2)
  : MovingEffect(loc2, life2, vect2), r(r2), g(g2), b(b2) {
  dr = r2 / life2;
  dg = g2 / life2;
  db = b2 / life2;
}

//*** FadeParticle ***//

bool FadeParticle::update() {
  r -= dr;
  g -= dg;
  b -= db;
  return MovingEffect::update();
}

void FadeParticle::draw() {
  Video::setAddBlender();
  Video::drawTransDot(loc, makecol(r, g, b));
  Video::setDefaultBlender();
}

//*** Explosion ***//
const IntRect EXPL_RECT(0, 0, 64, 64);
DATAFILE* Explosion::images = NULL;

Explosion::Explosion(const Point& loc2, const Vector& vect2) {
  loc = Point(loc2.x-EXPL_RECT.w/2, loc2.y-EXPL_RECT.h/2);
  life = EXPL_COUNT;
  vect = vect2;
  frame = 0;

  //Create particles comming off explosion
  if (prefs->complexExp) { //particles on complex explosions
    Vector diff;
    for (int c=0; c<64; c++) {
      diff.initRect(getrndd(2.0) - 1.0, getrndd(2.0) - 1.0);
      diff.add(vect);
      Game::moveEffect(new FadeParticle(loc2, 100, diff, 255, 0, 0));
    }
  }
}

void Explosion::initVideo(DATAFILE* root) {
  images = (DATAFILE*)root[EXPL].dat;
}

void Explosion::makeSound() {
  Sound::playRandomMapSound(SFX_DAT_EXPL00_WAV, 2, loc, getrnd(1250, 750));
}

bool Explosion::update() {
  frame++; //this is okay since our parent's update checks our "life"
  return MovingEffect::update();
}

void Explosion::draw() {
  if (prefs->complexExp)  //additive blending on complex explosions
    Video::setAddBlender();

  IntRect scrRect = IntRect(loc.x, loc.y, EXPL_RECT.w, EXPL_RECT.h);
  Video::drawTransSprite((BITMAP*)images[frame].dat, scrRect);

  if (prefs->complexExp) {//circle only on complex
    Video::drawTransCircle(scrRect.getCenter(), frame, makecol(255 - (255 * frame / EXPL_COUNT), 0, 0));
    Video::setDefaultBlender();
  }
}