//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Menus.h"
#include "Game.h"
#include "Sound.h"
#include "itanadat.h"
#include "Prefs.h"
#include "Network.h"
#include "NetworkDrivers.h"
#include "Client.h"
#include "Video.h"

int ret = -1;
char editBufs[6][40] = {"", "", "", "", "", ""};
static NetworkDrivers* drivers = NULL; //this is because the driverListGetter is in a callback

bool mainMenu() {
  doTitleScreen();
  doMainMenu();
  return false;
}

#define TITLECOLOR makecol(255, 255, 255)

void doTitleScreen() {
  BITMAP* titleScreen = load_jpeg("itana32.dat#title", NULL);
  if (titleScreen) {
    blit(titleScreen, screen, 0, 0, 0, 0, titleScreen->w, titleScreen->h);
    destroy_bitmap(titleScreen);
  }
  text_mode(-1);
  textprintf(screen, font, 0, 592, TITLECOLOR, "Version: %s", verno);
  textout(screen, font, "Copyright (C) 2001 by Jason Winnebeck", 504, 592, TITLECOLOR);
  textprintf_centre(screen, font, scrx/2, 0, TITLECOLOR, "Itana I: Old Enemies Reunite v%s", verno);
#ifdef ALLEGRO_MSVC
  textout_centre(screen, font, " Compiled with: MSVC++ 6", scrx/2, 12, TITLECOLOR);
#elif (defined ALLEGRO_DJGPP)
  textout_centre(screen, font, " Compiled with: DJGPP 2.03 the free C/C++ compiler at http://www.delorie.com/", scrx/2, 12, TITLECOLOR););
#endif
  textprintf_centre(screen, font, scrx/2, 24, TITLECOLOR, " And: %s", allegro_id);
  textout_centre(screen, font, " And: BGUI v2.0.2 modified by Jason Winnebeck", scrx/2, 36, TITLECOLOR);
  textprintf_centre(screen, font, scrx/2, 48, TITLECOLOR, " And: %s by %s", JPEG_DESC, JPEG_AUTHOR);
//textprintf_centre(screen, font, scrx/2, 60, TITLECOLOR, " And: JGMOD v%s by %s, made on %s\n", JGMOD_VERSION_STR, JGMOD_AUTHOR, JGMOD_DATE_STR);
  textprintf_centre(screen, font, scrx/2, 60, TITLECOLOR, " And: Network support from libnet by George Foot");
  textout_centre(screen, font, "Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this game in", scrx/2, 72, TITLECOLOR);
  textout_centre(screen, font, "its original archive.  If us wish to use code from Itana feel free to do so. If you", scrx/2, 84, TITLECOLOR);
  textout_centre(screen, font, "do a mention in the credits or a mail to gillius@webzone.net would be apprciated.", scrx/2, 96, TITLECOLOR);
}

void doMainMenu() {
  ret = -1; //dummy just to start loop
  while (ret < 0) {
    Video::setupGUIMouse();
    centre_dialog(mainDialog);
    //position_mouse(mainDialog[0].x, mainDialog[0].y);
    moveable_do_dialog(mainDialog, 2);
    switch(ret) {
    case 0:
      if (!quit())
        ret = -1;
      break;
    case 1:
      if (setupNetwork()) {
        ret = -1;
      } else {
        /*
        if (Video::setVideoMode(GAME_VIDEO_MODE))
          return;
        */
        Game::initVideo();
        Game::playGame();
        ((Client*)network)->disconnect();
        clear_keybuf();
        ret = -1;
      }
      break;
    case 2:
      instructions();
      ret = -1;
      break;
    case 3:
      doOptionsMenu();
      ret = -1;
      break;
    case 4:
      {
        int race = doRaceSelection();
        if (race != -1) {
          /*
          if (Video::setVideoMode(GAME_VIDEO_MODE))
            return;
          */
          Game::init();
          Game::initVideo();
          Game::generate(race);
          Game::playGame();
          clear_keybuf();
        }
        ret = -1;
      }
      break;
    }
  }
}

int doRaceSelection() {
  ret = -1;
  centre_dialog(raceDialog);
  moveable_do_dialog(raceDialog, 3);
  if (ret == 1)
    return raceDialog[GUI_SINGLE_IDX].d1 + MIN_ID_SHIP;
  else
    return -1;
}

void instructions() {
  ret = -1;
  centre_dialog(instDialog);
  moveable_do_dialog(instDialog, 3);
}

bool setupNetwork() {
  //display a dialog and connect to server
  ret = -1;
  drivers = network->getDrivers();
  sprintf(editBufs[0], get_config_string("network", "lastIP", "127.0.0.1"));
  sprintf(editBufs[1], get_config_string("network", "lastPort", (char*)DEFAULT_PORT_STR));
  sprintf(editBufs[4], get_config_string("network", "lastName", "Unnamed"));
  sprintf(editBufs[2], "%i", get_config_int("network", "uploadRate", 3200));
  sprintf(editBufs[3], "%i", get_config_int("network", "downloadRate", 3200));
  centre_dialog(connectDialog);
  moveable_do_dialog(connectDialog, 3);
  if (ret == 1) {
    network->setDriver(drivers->getId(connectDialog[GUI_DRIVERLIST_IDX].d1));
    //network->setRates(atoi(editBufs[2]), atoi(editBufs[3]));
    network->setRates(3200, 3200);
    sprintf(editBufs[5], "%s:%s", editBufs[0], editBufs[1]);
    if (((Client*)network)->connect(editBufs[5], editBufs[4], connectDialog[GUI_RACELIST_IDX].d1)) {
      billalert("Connection Error", "There was an error while connecting to the server:", 
                (char*)network->getLastError(), "&Ok", NULL, 'o', 0);
      return true;
    }
    //Save connection prefrences
    set_config_string("network", "lastIP", editBufs[0]);
    set_config_string("network", "lastPort", editBufs[1]);
    set_config_string("network", "lastName", editBufs[4]);
    set_config_int("network", "uploadRate", atoi(editBufs[2]));
    set_config_int("network", "downloadRate", atoi(editBufs[3]));
    return false;
  } else {
    return true;
  }
}

void doOptionsMenu() {
  ret = -1;
  while (ret == -1) {
    //Continue so setcontrols menu is separate of this window's settings.
    *OPT_SVOL = prefs->svol;
    setCheckBox(prefs->fastmouse, OPT_MOUSE);
    setCheckBox(prefs->vsync, OPT_VSYNC);
    setCheckBox(prefs->complexExp, OPT_COMPLEX);
    
    centre_dialog(optionsDialog);
    moveable_do_dialog(optionsDialog, 0);
    
    if (ret == 1) {
      prefs->svol = *OPT_SVOL;
      set_volume(prefs->svol, -1);
      getCheckBox(prefs->fastmouse, OPT_MOUSE);
      getCheckBox(prefs->vsync, OPT_VSYNC);
      getCheckBox(prefs->complexExp, OPT_COMPLEX);
    } else if (ret == 2) {
      //Do the setcontrols menu
      prefs->getControls(); //this will set ret to -1
      ret = -1;
    }
  }
}

void setCheckBox(int var, int* flag) {
  //helper used to init checkboxes based on booleans
  if (var)
    *flag = D_SELECTED;
  else
    *flag &= ~D_SELECTED;
}

void getCheckBox(int& var, int* flag) {
  //helper used to retrieve data from checkboxes
  var = ((*flag & D_SELECTED) != 0);
}

bool quit() {
  Sound::playSound(SFX_DAT_NEENEE_WAV);
  if (billalert("Quit", "Really want to quit Itana?", NULL, "&Yes", "Cancel", 'y', 27) == 1) {
    Sound::playSound(SFX_DAT_MOUSE_WAV);
    ret = 0;
    return true;
  } else {
    Sound::playSound(SFX_DAT_MOUSE_WAV);
    return false;
  }
}

//I/O Functions
void menu_pause() {
  clear_keybuf();
  while (!keypressed() && !(mouse_b)) {}
  clear_keybuf();
}

int setRet(void *dp3, int d2) {
  Sound::playSound(SFX_DAT_MOUSE_WAV);
  ret = d2;
  return D_O_K;
}

int d_check_exit(int msg, DIALOG *d, int c) {
  if (msg == MSG_IDLE)
    if (ret != -1)
      return D_CLOSE;
    else
      return D_O_K;

  return D_O_K;
}

char* driverListGetter(int index, int* list_size) {
  if (drivers == NULL) {
    //just a contigency plan, but drivers should be set
    *list_size = 0;
    return "Drivers not initalized";
  } else if (index < 0) {
    *list_size = drivers->getLength();
    return NULL;
  } else {
    return drivers->getName(index);
  }
}

char* raceListGetter(int index, int* list_size) {
  static char* strings[] = {
    "Human", "Zylex", "Ornon", "Alsetti"
  };

  if (index < 0) {
    *list_size = 4;
    return NULL;
  } else
    return strings[index];
}

char* connListGetter(int index, int* list_size) {
  static char* strings[] = {
    "Custom Connection Type"
  };

  if (index < 0) {
    *list_size = 1;
    return NULL;
  } else
    return strings[index];
}
