//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "itanadat.h"
#include "Interface.h"
#include "Video.h"
#include "IntRect.h"

const int     GAUGE_WIDTH  = 160; //based on statbar.bmp
const int     GAUGE_HEIGHT = 16;
const IntRect ENERGY_GAUGE(32,  16, GAUGE_WIDTH, GAUGE_HEIGHT);
const IntRect SHIELD_GAUGE(224, 16, GAUGE_WIDTH, GAUGE_HEIGHT);
const IntRect ARMOR_GAUGE (416, 16, GAUGE_WIDTH, GAUGE_HEIGHT);
const IntRect SCORE_GAUGE (592, 16,          48, GAUGE_HEIGHT);

const IntRect MAIN_BAR(0, 0, 640, 48);
const IntRect RADAR_AREA(640, 0, 160, 160);
const IntRect VOLATILE_AREA(640, 48, 160, 112);
  //Volatile area is the area NOT PROTECTED by Video and must be redrawn

Interface::Interface() {
  shield = energy = armor = GAUGE_WIDTH;
  shchange = enchange = archange = scchange = false;
  score = 0;
  redraw = true;
}

void Interface::setValues(double en, double sh, double ar, int sc) {
  //give setValues percentages of energy, shield, and armor
  int temp;
  temp = (int)(en * (double)ENERGY_GAUGE.w);
  if (temp != energy) {
    enchange = true;
    energy = temp;
  }

  temp = (int)(sh * SHIELD_GAUGE.w);
  if (temp != shield) {
    shchange = true;
    shield = temp;
  }

  temp = (int)(ar * ARMOR_GAUGE.w);
  if (temp != armor) {
    archange = true;
    armor = temp;
  }

  if (score != sc) {
    scchange = true;
    score = sc;
  }
}

void Interface::input() {
}

void Interface::update() {
}

void Interface::draw(BITMAP* dest, DATAFILE* sprites) {
  if (redraw) {
    //redraw everything
    enchange = shchange = archange = scchange = true;
    draw_rle_sprite(dest, (RLE_SPRITE*)sprites[GRFX_DAT_STATBAR_BMP].dat, 0, 0);
    Video::addNoClearRect(MAIN_BAR);
    redraw = false;
  }
  if (enchange) {
    blit((BITMAP*)sprites[GRFX_DAT_BAR_BMP].dat, dest, 0, 0, 
         ENERGY_GAUGE.x, ENERGY_GAUGE.y, energy, ENERGY_GAUGE.h);
    if (energy != ENERGY_GAUGE.w) {
      rectfill(dest, ENERGY_GAUGE.x+energy, ENERGY_GAUGE.y,
                     ENERGY_GAUGE.x+ENERGY_GAUGE.w-1, ENERGY_GAUGE.y+ENERGY_GAUGE.h-1, 0);
    }
    Video::addNoClearRect(ENERGY_GAUGE);
    enchange = false;
  }
  if (shchange) {
    blit((BITMAP*)sprites[GRFX_DAT_BAR_BMP].dat, dest, 0, 0, 
         SHIELD_GAUGE.x, SHIELD_GAUGE.y, shield, ENERGY_GAUGE.h);
    if (shield != ENERGY_GAUGE.w) {
      rectfill(dest, SHIELD_GAUGE.x+shield, SHIELD_GAUGE.y,
                     SHIELD_GAUGE.x+SHIELD_GAUGE.w-1, SHIELD_GAUGE.y+SHIELD_GAUGE.h-1, 0);
    }
    Video::addNoClearRect(SHIELD_GAUGE);
    shchange = false;
  }
  if (archange) {
    blit((BITMAP*)sprites[GRFX_DAT_BAR_BMP].dat, dest, 0, 0, 
         ARMOR_GAUGE.x, ARMOR_GAUGE.y, armor, ENERGY_GAUGE.h);
    if (armor != ENERGY_GAUGE.w) {
      rectfill(dest, ARMOR_GAUGE.x+armor, ARMOR_GAUGE.y,
                     ARMOR_GAUGE.x+ARMOR_GAUGE.w-1, ARMOR_GAUGE.y+ARMOR_GAUGE.h-1, 0);
    }
    Video::addNoClearRect(ARMOR_GAUGE);
    archange = false;
  }
  if (scchange) {
    rectfill(dest, SCORE_GAUGE.x, SCORE_GAUGE.y,
                   SCORE_GAUGE.x+SCORE_GAUGE.w-1, SCORE_GAUGE.y+SCORE_GAUGE.h-1, 0);
    Video::addNoClearRect(SCORE_GAUGE);
    scchange = false;
  }

  //always redraw the volatile area
  draw_rle_sprite(dest, (RLE_SPRITE*)sprites[GRFX_DAT_VOLBAR_BMP].dat,
                  VOLATILE_AREA.x, VOLATILE_AREA.y);
  Video::addNoClearRect(VOLATILE_AREA);
}