//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _GAME_H_
#define _GAME_H_

#include "Itana.h"
#include "MovingEntity.h"
#include "Entity.h"
#include "Effect.h"
class Interface;
class Radar;
class Ship;
class Base;
class Stars;

class Game {
public:
  static void construct();
  static void destruct();

  static void init();
    //initalizes Game, clearing all data as well, except that it adds the Planet
  static void initVideo();
    //initalizes Radar and Stars and the mouse.  Must be called when in GAME_VIDEO_MODE
  static void setPlayer(Ship* player2, Base* base);

  static void generate(int race);
    //generates a false game, used in single-play testing only!
  static void playGame();

  static void setFrame(int currFrame2);
  static void runToFrame(int currFrame2);
    //For network syncronization
  static int getFrame() { return currFrame; }
    //returns the current frame.  To be used by functions
    //that update every x frames (using the mod function)

  //when you pass an object to these functions, memory allocation is
  //handled by these functions.  Do not delete the object after you
  //call these functions
  static void moveEntity(OrbitingEntity* entity) { oEnts._MoveData(entity); }
  static void moveEntity(MovingEntity* entity) { mEnts._MoveData(entity); }
  static void moveEffect(Effect* effect) { effects._MoveData(effect); }

  static LinkList<MovingEntity>* getMovingEntities() { return &mEnts; }
  static LinkList<Entity>* getOrbitingEntities() { return &oEnts; }
    //These functions are used by the Radar class to render the radar

  static bool initForServer();
    //special init for the server, true on error
  static void doServerUpdate();
    //special update for the server
  static void closeForServer();
    //special shutdown for the server

private:
  static void gameLoop();

  static void doInput();      //Input phase
  static void doUpdate();     //Update phase (physics/calculations)
  static void doDraw();       //Draw phase
  static void doCollisions(); //Check for and perform collisions

  static int currFrame;//current known frame

  static Interface* const statusBar;
  static Radar* const radar;
  static Stars* const stars;
  static Ship* player; //the local player is included in the linklists below!
  static LinkList<MovingEntity> mEnts;   //collision is checked between mEntities
  static LinkList<Entity> oEnts;         //oEntities only collide with mEntities
  static LinkList<Effect> effects;
};

#endif