//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Bullet.h"
#include "BulletStats.h"
#include "Network.h"
#include "Game.h"

Bullet::Bullet(int type2) {
  id = type2;
  type = id - MIN_ID_BULLET;
}
 
Bullet::Bullet(const Point& p, const Vector& rel, double theta, int type2) {
  init(p, rel, theta, type2);
}

void Bullet::init(const Point& p, const Vector& rel, double theta, int type2) {
  type = type2 - MIN_ID_BULLET;
  id = type2;
  life = BULLETSTATS[type].life;
  Vector vector;
  vector.initPolar(theta, BULLETSTATS[type].speed);
  vector.add(rel);
  const double width = BULLETSTATS[type].width;
  const double height = BULLETSTATS[type].height;
  MovingEntity::init(Rect(p.x - width/2.0, p.y - height/2.0, width, height), vector);
  initScrLoc();
}

int Bullet::getDamage() {
  return BULLETSTATS[type].damage;
}

void Bullet::doCollision(Entity* other) {
  if ((owner != other) && !other->isBullet()) {
    //dont crash into our ship before leaving it, or into other bullets
    //Kill this bullet immediately.  The other object will handle damage
    life = 0;
  }
}

Packet* Bullet::makePacket() {
  //Makes a packet of an appropriate type
  DynamicEntityPacket* packet = new DynamicEntityPacket();
  packet->playerId = network->whoIsThis(owner);
  packet->frame = Game::getFrame();
  packet->objectId = id;
  packet->vect = vect;
  packet->loc.x = loc.x;
  packet->loc.y = loc.y;
  return packet;
}

void Bullet::usePacket(Packet* packet) {
  //Uses a packet if it is of appropriate type
  //DON'T FORGET TO CALL setOwner!
  if (packet->getType() == DYNAMICENTITY) {
    DynamicEntityPacket* data = (DynamicEntityPacket*)packet;
    type = id - MIN_ID_BULLET;
    life = BULLETSTATS[type].life;
    MovingEntity::init(Rect(data->loc.x, data->loc.y, 1.0, 1.0), data->vect);
    int currFrame = Game::getFrame();
    for(int c=data->frame; c<currFrame; c++)
      update();
  }
}

bool Bullet::update() {
  MovingEntity::update();
  if (--life < 0)
    return true;
  else
    return false;
}