//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "itanadat.h"
#include "AlsettiShip.h"
#include "ShipStats.h"
#include "Video.h"
#include "MovingEffect.h"
#include "Game.h"
#include "Vector.h"
#include "BlasterBullet.h"
#include "ParaBullet.h"
#include "Sound.h"

//The Alsetti engine is 6 wide and straight back

const double BLASTER_RECOIL = 0.4;
const double PARA_RECOIL = 0.32;

AlsettiShip::AlsettiShip() {
  type = ALSETTI_STATS;
  id = ID_ALSETTI_SHIP;
}

void AlsettiShip::init(const Rect& rect, const Vector& vect2) {
  Ship::init(rect, vect2);
}

void AlsettiShip::input() {
  Ship::input();
}

bool AlsettiShip::update() {
  return Ship::update();
}

void AlsettiShip::draw() {
  if (!dead) {
    Video::drawSprite(GRFX_DAT_ALSSHIP_BMP, loc, scrLoc, radToFix(theta));
    Ship::draw();
  }
}

void AlsettiShip::fire(int dir) {
  //Alsetti ships fire a fast blaster.  Direction does not matter.
  if (energy >= STATS[type].fireuse) {
    if (normalReload == 0) {
      Sound::playMapSound(SFX_DAT_LASER_WAV, loc.getCenter());
      Ship::fire(new BlasterBullet(loc.getCenter(), vect, theta), theta + PI, BLASTER_RECOIL);
      energy -= STATS[type].fireuse;
      normalReload = STATS[type].firedelay;
    }
    actions |= FIREUP;
  }
}

void AlsettiShip::special() {
  //Alsetti ships fire a parabolt
  if (control == CTRL_LOCAL && energy >= STATS[type].specialuse) {
    //Para bolts are sent explicitly over the network.
    if (specialReload == 0) {
      Sound::playMapSound(SFX_DAT_PARA_WAV, loc.getCenter());
      Ship::fire(new ParaBullet(loc.getCenter(), vect, theta), theta + PI, PARA_RECOIL);
      energy -= STATS[type].specialuse;
      specialReload = STATS[type].specialdelay;
    }
    actions |= FIRESPECIAL;
  }
}

void AlsettiShip::throwEngineParticle(const Vector& partVect) {
  if ((Game::getFrame() % 3) == 0) {
    Vector temp(-17, getrnd(7)-3);

    temp.rotate(theta);
    double midx = loc.x + loc.w/2;
    double midy = loc.y + loc.h/2;
    FadeParticle* newParticle = new FadeParticle(Point(midx + temp.getMagx(), midy + temp.getMagy()),
                                                 200, partVect, 255, 0, 0);
    Game::moveEffect(newParticle);
  }
}